/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date.DateWithTimeZoneOffset;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ElectronicRecordDetails;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidenceType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ValidationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.VerificationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Attachment;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class ElectronicRecordEvidence
extends IdentityEvidence {
    private final ValidationMethod validationMethod;
    private final VerificationMethod verificationMethod;
    private final IdentityVerifier verifier;
    private final DateWithTimeZoneOffset time;
    private final ElectronicRecordDetails recordDetails;

    public ElectronicRecordEvidence(ValidationMethod validationMethod, VerificationMethod verificationMethod, IdentityVerifier identityVerifier, DateWithTimeZoneOffset dateWithTimeZoneOffset, ElectronicRecordDetails electronicRecordDetails, List<Attachment> list) {
        super(IdentityEvidenceType.ELECTRONIC_RECORD, list);
        this.validationMethod = validationMethod;
        this.verificationMethod = verificationMethod;
        this.time = dateWithTimeZoneOffset;
        this.verifier = identityVerifier;
        this.recordDetails = electronicRecordDetails;
    }

    public ValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public VerificationMethod getVerificationMethod() {
        return this.verificationMethod;
    }

    public IdentityVerifier getVerifier() {
        return this.verifier;
    }

    public DateWithTimeZoneOffset getVerificationTime() {
        return this.time;
    }

    public ElectronicRecordDetails getRecordDetails() {
        return this.recordDetails;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        if (this.getValidationMethod() != null) {
            jSONObject.put("validation_method", this.getValidationMethod().toJSONObject());
        }
        if (this.getVerificationMethod() != null) {
            jSONObject.put("verification_method", this.getVerificationMethod().toJSONObject());
        }
        if (this.getVerifier() != null) {
            jSONObject.put("verifier", this.getVerifier().toJSONObject());
        }
        if (this.getVerificationTime() != null) {
            jSONObject.put("time", this.getVerificationTime().toISO8601String());
        }
        if (this.getRecordDetails() != null) {
            jSONObject.put("record", this.getRecordDetails().toJSONObject());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ElectronicRecordEvidence)) {
            return false;
        }
        ElectronicRecordEvidence electronicRecordEvidence = (ElectronicRecordEvidence)object;
        return Objects.equals(this.getValidationMethod(), electronicRecordEvidence.getValidationMethod()) && Objects.equals(this.getVerificationMethod(), electronicRecordEvidence.getVerificationMethod()) && Objects.equals(this.getVerifier(), electronicRecordEvidence.getVerifier()) && Objects.equals(this.getVerificationTime(), electronicRecordEvidence.getVerificationTime()) && Objects.equals(this.getRecordDetails(), electronicRecordEvidence.getRecordDetails());
    }

    public int hashCode() {
        return Objects.hash(this.getValidationMethod(), this.getVerificationMethod(), this.getVerifier(), this.getVerificationTime(), this.getRecordDetails());
    }

    public static ElectronicRecordEvidence parse(JSONObject jSONObject) throws ParseException {
        ElectronicRecordEvidence.ensureType(IdentityEvidenceType.ELECTRONIC_RECORD, jSONObject);
        ValidationMethod validationMethod = null;
        if (jSONObject.get("validation_method") != null) {
            validationMethod = ValidationMethod.parse(JSONObjectUtils.getJSONObject(jSONObject, "validation_method"));
        }
        VerificationMethod verificationMethod = null;
        if (jSONObject.get("verification_method") != null) {
            verificationMethod = VerificationMethod.parse(JSONObjectUtils.getJSONObject(jSONObject, "verification_method"));
        }
        IdentityVerifier identityVerifier = null;
        if (jSONObject.get("verifier") != null) {
            identityVerifier = IdentityVerifier.parse(JSONObjectUtils.getJSONObject(jSONObject, "verifier"));
        }
        DateWithTimeZoneOffset dateWithTimeZoneOffset = null;
        if (jSONObject.get("time") != null) {
            dateWithTimeZoneOffset = DateWithTimeZoneOffset.parseISO8601String(JSONObjectUtils.getString(jSONObject, "time"));
        }
        ElectronicRecordDetails electronicRecordDetails = null;
        if (jSONObject.get("record") != null) {
            electronicRecordDetails = ElectronicRecordDetails.parse(JSONObjectUtils.getJSONObject(jSONObject, "record"));
        }
        List<Attachment> list = null;
        if (jSONObject.get("attachments") != null) {
            list = Attachment.parseList(JSONObjectUtils.getJSONArray(jSONObject, "attachments"));
        }
        return new ElectronicRecordEvidence(validationMethod, verificationMethod, identityVerifier, dateWithTimeZoneOffset, electronicRecordDetails, list);
    }
}

