/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date.SimpleDate;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.PersonalNumber;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ReferenceNumber;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.VouchType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.Voucher;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class Attestation {
    private final VouchType type;
    private final ReferenceNumber referenceNumber;
    private final PersonalNumber personalNumber;
    private final SimpleDate dateOfIssuance;
    private final SimpleDate dateOfExpiry;
    private final Voucher voucher;

    public Attestation(VouchType vouchType, ReferenceNumber referenceNumber, PersonalNumber personalNumber, SimpleDate simpleDate, SimpleDate simpleDate2, Voucher voucher) {
        Objects.requireNonNull(vouchType);
        this.type = vouchType;
        this.referenceNumber = referenceNumber;
        this.personalNumber = personalNumber;
        this.dateOfIssuance = simpleDate;
        this.dateOfExpiry = simpleDate2;
        this.voucher = voucher;
    }

    public VouchType getType() {
        return this.type;
    }

    public ReferenceNumber getReferenceNumber() {
        return this.referenceNumber;
    }

    public PersonalNumber getPersonalNumber() {
        return this.personalNumber;
    }

    public SimpleDate getDateOfIssuance() {
        return this.dateOfIssuance;
    }

    public SimpleDate getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public Voucher getVoucher() {
        return this.voucher;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("type", this.getType().getValue());
        if (this.getReferenceNumber() != null) {
            jSONObject2.put("reference_number", this.getReferenceNumber().getValue());
        }
        if (this.getPersonalNumber() != null) {
            jSONObject2.put("personal_number", this.getPersonalNumber().getValue());
        }
        if (this.getDateOfIssuance() != null) {
            jSONObject2.put("date_of_issuance", this.getDateOfIssuance().toISO8601String());
        }
        if (this.getDateOfExpiry() != null) {
            jSONObject2.put("date_of_expiry", this.getDateOfExpiry().toISO8601String());
        }
        if (this.getVoucher() != null && !(jSONObject = this.getVoucher().toJSONObject()).isEmpty()) {
            jSONObject2.put("voucher", jSONObject);
        }
        return jSONObject2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Attestation)) {
            return false;
        }
        Attestation attestation = (Attestation)object;
        return this.getType().equals(attestation.getType()) && Objects.equals(this.getReferenceNumber(), attestation.getReferenceNumber()) && Objects.equals(this.getPersonalNumber(), attestation.getPersonalNumber()) && Objects.equals(this.getDateOfIssuance(), attestation.getDateOfIssuance()) && Objects.equals(this.getDateOfExpiry(), attestation.getDateOfExpiry()) && Objects.equals(this.getVoucher(), attestation.getVoucher());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getReferenceNumber(), this.getPersonalNumber(), this.getDateOfIssuance(), this.getDateOfExpiry(), this.getVoucher());
    }

    public static Attestation parse(JSONObject jSONObject) throws ParseException {
        try {
            VouchType vouchType = new VouchType(JSONObjectUtils.getString(jSONObject, "type"));
            ReferenceNumber referenceNumber = null;
            if (jSONObject.get("reference_number") != null) {
                referenceNumber = new ReferenceNumber(JSONObjectUtils.getString(jSONObject, "reference_number"));
            }
            PersonalNumber personalNumber = null;
            if (jSONObject.get("personal_number") != null) {
                personalNumber = new PersonalNumber(JSONObjectUtils.getString(jSONObject, "personal_number"));
            }
            SimpleDate simpleDate = null;
            if (jSONObject.get("date_of_issuance") != null) {
                simpleDate = SimpleDate.parseISO8601String(JSONObjectUtils.getString(jSONObject, "date_of_issuance"));
            }
            SimpleDate simpleDate2 = null;
            if (jSONObject.get("date_of_expiry") != null) {
                simpleDate2 = SimpleDate.parseISO8601String(JSONObjectUtils.getString(jSONObject, "date_of_expiry"));
            }
            Voucher voucher = null;
            if (jSONObject.get("voucher") != null) {
                voucher = Voucher.parse(JSONObjectUtils.getJSONObject(jSONObject, "voucher"));
            }
            return new Attestation(vouchType, referenceNumber, personalNumber, simpleDate, simpleDate2, voucher);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), exception);
        }
    }
}

