/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims.ISO3166_1Alpha2CountryCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims.ISO3166_1Alpha3CountryCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims.ISO3166_3CountryCode;

public abstract class CountryCode
extends Identifier {
    private static final long serialVersionUID = -6171424661935191539L;

    protected CountryCode(String string) {
        super(string);
    }

    public int length() {
        return this.getValue().length();
    }

    public ISO3166_1Alpha2CountryCode toISO3166_1Alpha2CountryCode() {
        return (ISO3166_1Alpha2CountryCode)this;
    }

    public ISO3166_1Alpha3CountryCode toISO3166_1Alpha3CountryCode() {
        return (ISO3166_1Alpha3CountryCode)this;
    }

    public ISO3166_3CountryCode toISO3166_3CountryCode() {
        return (ISO3166_3CountryCode)this;
    }

    public static CountryCode parse(String string) throws ParseException {
        if (3 == string.length()) {
            return ISO3166_1Alpha3CountryCode.parse(string);
        }
        if (2 == string.length()) {
            return ISO3166_1Alpha2CountryCode.parse(string);
        }
        if (4 == string.length()) {
            return ISO3166_3CountryCode.parse(string);
        }
        throw new ParseException("The country code must be 3, 2 or 4 letters");
    }

    @Override
    public abstract boolean equals(Object var1);
}

