/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class Prompt
extends LinkedHashSet<Type> {
    private static final long serialVersionUID = -3672900533669609699L;

    public Prompt() {
    }

    public Prompt(Type ... typeArray) {
        this.addAll(Arrays.asList(typeArray));
    }

    public Prompt(String ... stringArray) {
        for (String string : stringArray) {
            try {
                this.add(Type.parse(string));
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException.getMessage(), parseException);
            }
        }
    }

    public boolean isValid() {
        return this.size() <= 1 || !this.contains((Object)Type.NONE);
    }

    public List<String> toStringList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        for (Type type : this) {
            arrayList.add(type.toString());
        }
        return arrayList;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(((Type)((Object)iterator.next())).toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static Prompt parse(Collection<String> collection) throws ParseException {
        if (collection == null) {
            return null;
        }
        Prompt prompt = new Prompt();
        for (String string : collection) {
            prompt.add(Type.parse(string));
        }
        if (!prompt.isValid()) {
            throw new ParseException("Invalid prompt: " + collection);
        }
        return prompt;
    }

    public static Prompt parse(String string) throws ParseException {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        Prompt prompt = new Prompt();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            prompt.add(Type.parse(stringTokenizer.nextToken()));
        }
        if (!prompt.isValid()) {
            throw new ParseException("Invalid prompt: " + string);
        }
        return prompt;
    }

    public static enum Type {
        NONE,
        LOGIN,
        CONSENT,
        SELECT_ACCOUNT,
        CREATE;


        public String toString() {
            return super.toString().toLowerCase();
        }

        public static Type parse(String string) throws ParseException {
            if (StringUtils.isBlank(string)) {
                throw new ParseException("Null or empty prompt type string");
            }
            if ("none".equals(string)) {
                return NONE;
            }
            if ("login".equals(string)) {
                return LOGIN;
            }
            if ("consent".equals(string)) {
                return CONSENT;
            }
            if ("select_account".equals(string)) {
                return SELECT_ACCOUNT;
            }
            if ("create".equals(string)) {
                return CREATE;
            }
            throw new ParseException("Unknown prompt type: " + string);
        }
    }
}

