/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.PlainJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class BackChannelLogoutRequest
extends AbstractRequest {
    private final JWT logoutToken;

    public BackChannelLogoutRequest(URI uRI, JWT jWT) {
        super(uRI);
        if (jWT == null) {
            throw new IllegalArgumentException("The logout token must not be null");
        }
        if (jWT instanceof PlainJWT) {
            throw new IllegalArgumentException("The logout token must not be unsecured (plain)");
        }
        this.logoutToken = jWT;
    }

    public JWT getLogoutToken() {
        return this.logoutToken;
    }

    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        try {
            linkedHashMap.put("logout_token", Collections.singletonList(this.logoutToken.serialize()));
        }
        catch (IllegalStateException illegalStateException) {
            throw new SerializeException("Couldn't serialize logout token: " + illegalStateException.getMessage(), illegalStateException);
        }
        return linkedHashMap;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        hTTPRequest.setQuery(URLUtils.serializeParameters(this.toParameters()));
        return hTTPRequest;
    }

    public static BackChannelLogoutRequest parse(Map<String, List<String>> map) throws ParseException {
        return BackChannelLogoutRequest.parse(null, map);
    }

    public static BackChannelLogoutRequest parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        JWT jWT;
        String string = MultivaluedMapUtils.getFirstValue(map, "logout_token");
        if (string == null) {
            throw new ParseException("Missing logout_token parameter");
        }
        try {
            jWT = JWTParser.parse(string);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid logout token: " + parseException.getMessage(), parseException);
        }
        try {
            return new BackChannelLogoutRequest(uRI, jWT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public static BackChannelLogoutRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        if (!HTTPRequest.Method.POST.equals((Object)hTTPRequest.getMethod())) {
            throw new ParseException("HTTP POST required");
        }
        String string = hTTPRequest.getQuery();
        if (string == null) {
            throw new ParseException("Missing URI query string");
        }
        Map<String, List<String>> map = URLUtils.parseParameters(string);
        return BackChannelLogoutRequest.parse(URIUtils.getBaseURI(hTTPRequest.getURI()), map);
    }
}

