/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util;

import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.parser.JSONParser;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReader;

public final class JSONUtils {
    public static Object parseJSON(String string) throws ParseException {
        try {
            return new JSONParser(640).parse(string);
        }
        catch (macromedia.jdbc.sqlserver.externals.net.minidev.json.parser.ParseException parseException) {
            throw new ParseException("Invalid JSON: " + parseException.getMessage(), parseException);
        }
        catch (NullPointerException nullPointerException) {
            throw new ParseException("The JSON string must not be null", nullPointerException);
        }
        catch (Exception exception) {
            throw new ParseException("Unexpected exception: " + exception.getMessage(), exception);
        }
    }

    public static Object parseJSONKeepingOrder(String string) throws ParseException {
        try {
            return new JSONParser(640).parse(string, new JsonReader().DEFAULT_ORDERED);
        }
        catch (macromedia.jdbc.sqlserver.externals.net.minidev.json.parser.ParseException parseException) {
            throw new ParseException("Invalid JSON: " + parseException.getMessage(), parseException);
        }
    }

    public static <T> T to(Object object, Class<T> clazz) throws ParseException {
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new ParseException("Unexpected type: " + object.getClass());
        }
        return (T)object;
    }

    public static boolean toBoolean(Object object) throws ParseException {
        return JSONUtils.to(object, Boolean.class);
    }

    public static Number toNumber(Object object) throws ParseException {
        return JSONUtils.to(object, Number.class);
    }

    public static String toString(Object object) throws ParseException {
        return JSONUtils.to(object, String.class);
    }

    public static List<?> toList(Object object) throws ParseException {
        return JSONUtils.to(object, List.class);
    }

    public static List<String> toStringList(Object object) throws ParseException {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            for (Object obj : JSONUtils.toList(object)) {
                linkedList.add((String)obj);
            }
        }
        catch (ClassCastException classCastException) {
            throw new ParseException("Item not a string");
        }
        return linkedList;
    }

    private JSONUtils() {
    }
}

