/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token;

import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class BearerAccessToken
extends AccessToken {
    private static final long serialVersionUID = 2387121016151061194L;

    public BearerAccessToken() {
        this(32);
    }

    public BearerAccessToken(int n2) {
        this(n2, 0L, null);
    }

    public BearerAccessToken(long l2, Scope scope) {
        this(32, l2, scope);
    }

    public BearerAccessToken(int n2, long l2, Scope scope) {
        super(AccessTokenType.BEARER, n2, l2, scope);
    }

    public BearerAccessToken(String string) {
        this(string, 0L, null, null);
    }

    public BearerAccessToken(String string, long l2, Scope scope) {
        this(string, l2, scope, null);
    }

    public BearerAccessToken(String string, long l2, Scope scope, TokenTypeURI tokenTypeURI) {
        super(AccessTokenType.BEARER, string, l2, scope, tokenTypeURI);
    }

    @Override
    public String toAuthorizationHeader() {
        return "Bearer " + this.getValue();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof BearerAccessToken && this.toString().equals(object.toString());
    }

    public static BearerAccessToken parse(JSONObject jSONObject) throws ParseException {
        AccessTokenUtils.parseAndEnsureType(jSONObject, AccessTokenType.BEARER);
        String string = AccessTokenUtils.parseValue(jSONObject);
        long l2 = AccessTokenUtils.parseLifetime(jSONObject);
        Scope scope = AccessTokenUtils.parseScope(jSONObject);
        TokenTypeURI tokenTypeURI = AccessTokenUtils.parseIssuedTokenType(jSONObject);
        return new BearerAccessToken(string, l2, scope, tokenTypeURI);
    }

    public static BearerAccessToken parse(String string) throws ParseException {
        return new BearerAccessToken(AccessTokenUtils.parseValueFromHeader(string, AccessTokenType.BEARER));
    }

    public static BearerAccessToken parse(Map<String, List<String>> map) throws ParseException {
        return new BearerAccessToken(AccessTokenUtils.parseValueFromQueryParameters(map, AccessTokenType.BEARER));
    }

    public static BearerAccessToken parse(HTTPRequest hTTPRequest) throws ParseException {
        String string = hTTPRequest.getAuthorization();
        if (string != null) {
            return BearerAccessToken.parse(string);
        }
        Map<String, List<String>> map = hTTPRequest.getQueryParameters();
        return BearerAccessToken.parse(map);
    }
}

