/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.jarm;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.ImmutableSecret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.RemoteJWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEDecryptionKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSVerificationKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.EncryptedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.PlainJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.ClockSkewAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.DefaultJWTProcessor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GeneralException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientInformation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.jarm.JARMClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators.AbstractJWTValidator;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JARMValidator
extends AbstractJWTValidator
implements ClockSkewAware {
    public JARMValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, JWKSet jWKSet) {
        this(issuer, clientID, new JWSVerificationKeySelector(jWSAlgorithm, new ImmutableJWKSet(jWKSet)), null);
    }

    public JARMValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, URL uRL) {
        this(issuer, clientID, jWSAlgorithm, uRL, null);
    }

    public JARMValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, URL uRL, ResourceRetriever resourceRetriever) {
        this(issuer, clientID, new JWSVerificationKeySelector(jWSAlgorithm, new RemoteJWKSet(uRL, resourceRetriever)), null);
    }

    public JARMValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, Secret secret) {
        this(issuer, clientID, new JWSVerificationKeySelector(jWSAlgorithm, new ImmutableSecret(secret.getValueBytes())), null);
    }

    public JARMValidator(Issuer issuer, ClientID clientID, JWSKeySelector jWSKeySelector, JWEKeySelector jWEKeySelector) {
        super(issuer, clientID, jWSKeySelector, jWEKeySelector);
    }

    public JWTClaimsSet validate(String string) throws BadJOSEException, JOSEException {
        try {
            return this.validate(JWTParser.parse(string));
        }
        catch (ParseException parseException) {
            throw new BadJOSEException("Invalid JWT: " + parseException.getMessage(), parseException);
        }
    }

    public JWTClaimsSet validate(JWT jWT) throws BadJOSEException, JOSEException {
        if (jWT instanceof SignedJWT) {
            return this.validate((SignedJWT)jWT);
        }
        if (jWT instanceof EncryptedJWT) {
            return this.validate((EncryptedJWT)jWT);
        }
        if (jWT instanceof PlainJWT) {
            throw new BadJWTException("The JWT must not be plain (unsecured)");
        }
        throw new BadJOSEException("Unexpected JWT type: " + jWT.getClass());
    }

    private JWTClaimsSet validate(SignedJWT signedJWT) throws BadJOSEException, JOSEException {
        if (this.getJWSKeySelector() == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        defaultJWTProcessor.setJWSKeySelector(this.getJWSKeySelector());
        defaultJWTProcessor.setJWTClaimsSetVerifier(new JARMClaimsVerifier(this.getExpectedIssuer(), this.getClientID(), this.getMaxClockSkew()));
        return defaultJWTProcessor.process(signedJWT, null);
    }

    private JWTClaimsSet validate(EncryptedJWT encryptedJWT) throws BadJOSEException, JOSEException {
        if (this.getJWEKeySelector() == null) {
            throw new BadJWTException("Decryption of JWTs not configured");
        }
        if (this.getJWSKeySelector() == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        defaultJWTProcessor.setJWSKeySelector(this.getJWSKeySelector());
        defaultJWTProcessor.setJWEKeySelector(this.getJWEKeySelector());
        defaultJWTProcessor.setJWTClaimsSetVerifier(new JARMClaimsVerifier(this.getExpectedIssuer(), this.getClientID(), this.getMaxClockSkew()));
        return defaultJWTProcessor.process(encryptedJWT, null);
    }

    protected static JWSKeySelector createJWSKeySelector(AuthorizationServerMetadata authorizationServerMetadata, ClientInformation clientInformation) throws GeneralException {
        JWSAlgorithm jWSAlgorithm = clientInformation.getMetadata().getAuthorizationJWSAlg();
        if (authorizationServerMetadata.getAuthorizationJWSAlgs() == null) {
            throw new GeneralException("Missing Authorization Server authorization_signing_alg_values_supported parameter");
        }
        if (!authorizationServerMetadata.getAuthorizationJWSAlgs().contains(jWSAlgorithm)) {
            throw new GeneralException("The Authorization Server doesn't support " + jWSAlgorithm + " authorization responses");
        }
        if (Algorithm.NONE.equals(jWSAlgorithm)) {
            return null;
        }
        if (JWSAlgorithm.Family.RSA.contains(jWSAlgorithm) || JWSAlgorithm.Family.EC.contains(jWSAlgorithm)) {
            URL uRL;
            try {
                uRL = authorizationServerMetadata.getJWKSetURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new GeneralException("Invalid jwk set URI: " + malformedURLException.getMessage(), malformedURLException);
            }
            RemoteJWKSet remoteJWKSet = new RemoteJWKSet(uRL);
            return new JWSVerificationKeySelector(jWSAlgorithm, remoteJWKSet);
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains(jWSAlgorithm)) {
            Secret secret = clientInformation.getSecret();
            if (secret == null) {
                throw new GeneralException("Missing client secret");
            }
            return new JWSVerificationKeySelector(jWSAlgorithm, new ImmutableSecret(secret.getValueBytes()));
        }
        throw new GeneralException("Unsupported JWS algorithm: " + jWSAlgorithm);
    }

    protected static JWEKeySelector createJWEKeySelector(AuthorizationServerMetadata authorizationServerMetadata, ClientInformation clientInformation, JWKSource jWKSource) throws GeneralException {
        JWEAlgorithm jWEAlgorithm = clientInformation.getMetadata().getAuthorizationJWEAlg();
        EncryptionMethod encryptionMethod = clientInformation.getMetadata().getAuthorizationJWEEnc();
        if (jWEAlgorithm == null) {
            return null;
        }
        if (encryptionMethod == null) {
            throw new GeneralException("Missing required authorization response JWE encryption method for " + jWEAlgorithm);
        }
        if (authorizationServerMetadata.getAuthorizationJWEAlgs() == null || !authorizationServerMetadata.getAuthorizationJWEAlgs().contains(jWEAlgorithm)) {
            throw new GeneralException("The Authorization Server doesn't support " + jWEAlgorithm + " authorization responses");
        }
        if (authorizationServerMetadata.getAuthorizationJWEEncs() == null || !authorizationServerMetadata.getAuthorizationJWEEncs().contains(encryptionMethod)) {
            throw new GeneralException("The Authorization Server doesn't support " + jWEAlgorithm + " / " + encryptionMethod + " authorization responses");
        }
        return new JWEDecryptionKeySelector(jWEAlgorithm, encryptionMethod, jWKSource);
    }

    public static JARMValidator create(AuthorizationServerMetadata authorizationServerMetadata, ClientInformation clientInformation, JWKSource jWKSource) throws GeneralException {
        JWSKeySelector jWSKeySelector = JARMValidator.createJWSKeySelector(authorizationServerMetadata, clientInformation);
        JWEKeySelector jWEKeySelector = JARMValidator.createJWEKeySelector(authorizationServerMetadata, clientInformation, jWKSource);
        return new JARMValidator(authorizationServerMetadata.getIssuer(), clientInformation.getID(), jWSKeySelector, jWEKeySelector);
    }

    public static JARMValidator create(AuthorizationServerMetadata authorizationServerMetadata, ClientInformation clientInformation) throws GeneralException {
        return JARMValidator.create(authorizationServerMetadata, clientInformation, null);
    }

    public static JARMValidator create(Issuer issuer, ClientInformation clientInformation) throws GeneralException, IOException {
        return JARMValidator.create(issuer, clientInformation, null, 0, 0);
    }

    public static JARMValidator create(Issuer issuer, ClientInformation clientInformation, JWKSource jWKSource, int n2, int n3) throws GeneralException, IOException {
        AuthorizationServerMetadata authorizationServerMetadata;
        try {
            authorizationServerMetadata = OIDCProviderMetadata.resolve(issuer, n2, n3);
        }
        catch (Exception exception) {
            authorizationServerMetadata = AuthorizationServerMetadata.resolve(issuer, n2, n3);
        }
        return JARMValidator.create(authorizationServerMetadata, clientInformation, jWKSource);
    }
}

