/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.jarm;

import java.util.Date;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.ClockSkewAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators.BadJWTExceptions;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JARMClaimsVerifier
implements ClockSkewAware,
JWTClaimsSetVerifier {
    private final Issuer expectedIssuer;
    private final ClientID expectedClientID;
    private int maxClockSkew;

    public JARMClaimsVerifier(Issuer issuer, ClientID clientID, int n2) {
        if (issuer == null) {
            throw new IllegalArgumentException("The expected ID token issuer must not be null");
        }
        this.expectedIssuer = issuer;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.expectedClientID = clientID;
        this.setMaxClockSkew(n2);
    }

    public Issuer getExpectedIssuer() {
        return this.expectedIssuer;
    }

    public ClientID getClientID() {
        return this.expectedClientID;
    }

    @Override
    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    @Override
    public void setMaxClockSkew(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The max clock skew must be zero or positive");
        }
        this.maxClockSkew = n2;
    }

    public void verify(JWTClaimsSet jWTClaimsSet, SecurityContext securityContext) throws BadJWTException {
        String string = jWTClaimsSet.getIssuer();
        if (string == null) {
            throw BadJWTExceptions.MISSING_ISS_CLAIM_EXCEPTION;
        }
        if (!this.expectedIssuer.getValue().equals(string)) {
            throw new BadJWTException("Unexpected JWT issuer: " + string);
        }
        List<String> list = jWTClaimsSet.getAudience();
        if (list == null || list.isEmpty()) {
            throw BadJWTExceptions.MISSING_AUD_CLAIM_EXCEPTION;
        }
        if (!list.contains(this.expectedClientID.getValue())) {
            throw new BadJWTException("Unexpected JWT audience: " + list);
        }
        Date date = jWTClaimsSet.getExpirationTime();
        if (date == null) {
            throw BadJWTExceptions.MISSING_EXP_CLAIM_EXCEPTION;
        }
        Date date2 = new Date();
        if (!DateUtils.isAfter(date, date2, this.maxClockSkew)) {
            throw BadJWTExceptions.EXPIRED_EXCEPTION;
        }
    }
}

