/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class UserCode
extends Identifier {
    private static final long serialVersionUID = 6249537737406015901L;
    public static final String LETTER_CHAR_SET = "BCDFGHJKLMNPQRSTVWXZ";
    public static final String DIGIT_CHAR_SET = "0123456789";
    private final String charset;

    public UserCode(String string, String string2) {
        super(string);
        this.charset = string2;
    }

    public UserCode(String string) {
        this(string, LETTER_CHAR_SET);
    }

    public UserCode() {
        this(LETTER_CHAR_SET, 8);
    }

    public UserCode(String string, int n2) {
        this(UserCode.generateValue(string, n2), string);
    }

    private static String generateValue(String string, int n2) {
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("The charset must not be null or empty string");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0 && i2 % 4 == 0) {
                stringBuilder.append('-');
            }
            stringBuilder.append(string.charAt(secureRandom.nextInt(string.length())));
        }
        return stringBuilder.toString();
    }

    public String getCharset() {
        return this.charset;
    }

    public String getStrippedValue() {
        return UserCode.stripIllegalChars(this.getValue(), this.getCharset());
    }

    @Override
    public int compareTo(Identifier identifier) {
        if (!(identifier instanceof UserCode)) {
            return super.compareTo(identifier);
        }
        return this.getStrippedValue().compareTo(((UserCode)identifier).getStrippedValue());
    }

    @Override
    public int hashCode() {
        return this.getStrippedValue() != null ? this.getStrippedValue().hashCode() : 0;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof UserCode && this.getStrippedValue().equals(((UserCode)object).getStrippedValue());
    }

    public static String stripIllegalChars(String string, String string2) {
        if (string2 == null) {
            return string.toUpperCase();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : string.toUpperCase().toCharArray()) {
            if (string2.indexOf(c2) < 0) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

