/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device.DeviceAuthorizationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class DeviceAuthorizationErrorResponse
extends DeviceAuthorizationResponse
implements ErrorResponse {
    private static final Set<ErrorObject> STANDARD_ERRORS;
    private final ErrorObject error;

    public static Set<ErrorObject> getStandardErrors() {
        return STANDARD_ERRORS;
    }

    protected DeviceAuthorizationErrorResponse() {
        this.error = null;
    }

    public DeviceAuthorizationErrorResponse(ErrorObject errorObject) {
        if (errorObject == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = errorObject;
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.error == null) {
            return jSONObject;
        }
        jSONObject.put("error", this.error.getCode());
        if (this.error.getDescription() != null) {
            jSONObject.put("error_description", this.error.getDescription());
        }
        if (this.error.getURI() != null) {
            jSONObject.put("error_uri", this.error.getURI().toString());
        }
        return jSONObject;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        int n2 = this.error != null && this.error.getHTTPStatusCode() > 0 ? this.error.getHTTPStatusCode() : 400;
        HTTPResponse hTTPResponse = new HTTPResponse(n2);
        if (this.error == null) {
            return hTTPResponse;
        }
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        hTTPResponse.setContent(this.toJSONObject().toString());
        return hTTPResponse;
    }

    public static DeviceAuthorizationErrorResponse parse(JSONObject jSONObject) throws ParseException {
        ErrorObject errorObject;
        if (!jSONObject.containsKey("error")) {
            return new DeviceAuthorizationErrorResponse();
        }
        try {
            String string = JSONObjectUtils.getString(jSONObject, "error");
            String string2 = JSONObjectUtils.getString(jSONObject, "error_description", null);
            URI uRI = JSONObjectUtils.getURI(jSONObject, "error_uri", null);
            errorObject = new ErrorObject(string, string2, 400, uRI);
        }
        catch (ParseException parseException) {
            throw new ParseException("Missing or invalid token error response parameter: " + parseException.getMessage(), parseException);
        }
        return new DeviceAuthorizationErrorResponse(errorObject);
    }

    public static DeviceAuthorizationErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCodeNotOK();
        return new DeviceAuthorizationErrorResponse(ErrorObject.parse(hTTPResponse));
    }

    static {
        HashSet<ErrorObject> hashSet = new HashSet<ErrorObject>();
        hashSet.add(OAuth2Error.INVALID_REQUEST);
        hashSet.add(OAuth2Error.INVALID_CLIENT);
        hashSet.add(OAuth2Error.INVALID_SCOPE);
        STANDARD_ERRORS = Collections.unmodifiableSet(hashSet);
    }
}

