/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.AuthRequestID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBAErrorDelivery;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBATokenDelivery;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public abstract class CIBAPushCallback
extends ProtectedResourceRequest {
    private final AuthRequestID authRequestID;

    public CIBAPushCallback(URI uRI, BearerAccessToken bearerAccessToken, AuthRequestID authRequestID) {
        super(uRI, bearerAccessToken);
        if (authRequestID == null) {
            throw new IllegalArgumentException("The auth_req_id must not be null");
        }
        this.authRequestID = authRequestID;
    }

    public abstract boolean indicatesSuccess();

    public AuthRequestID getAuthRequestID() {
        return this.authRequestID;
    }

    public CIBATokenDelivery toTokenDelivery() {
        return (CIBATokenDelivery)this;
    }

    public CIBAErrorDelivery toErrorDelivery() {
        return (CIBAErrorDelivery)this;
    }

    public static CIBAPushCallback parse(HTTPRequest hTTPRequest) throws ParseException {
        JSONObject jSONObject = hTTPRequest.getQueryAsJSONObject();
        if (jSONObject.containsKey("error")) {
            return CIBAErrorDelivery.parse(hTTPRequest);
        }
        return CIBATokenDelivery.parse(hTTPRequest);
    }
}

