/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.TLSClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class PKITLSClientAuthentication
extends TLSClientAuthentication {
    private final String certSubjectDN;

    public PKITLSClientAuthentication(ClientID clientID, SSLSocketFactory sSLSocketFactory) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID, sSLSocketFactory);
        this.certSubjectDN = null;
    }

    @Deprecated
    public PKITLSClientAuthentication(ClientID clientID, String string) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID, (X509Certificate)null);
        if (string == null) {
            throw new IllegalArgumentException("The X.509 client certificate subject DN must not be null");
        }
        this.certSubjectDN = string;
    }

    public PKITLSClientAuthentication(ClientID clientID, X509Certificate x509Certificate) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID, x509Certificate);
        if (x509Certificate == null) {
            throw new IllegalArgumentException("The X.509 client certificate must not be null");
        }
        this.certSubjectDN = x509Certificate.getSubjectX500Principal().getName();
    }

    public String getClientX509CertificateSubjectDN() {
        return this.certSubjectDN;
    }

    public static PKITLSClientAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        String string = hTTPRequest.getQuery();
        if (string == null) {
            throw new ParseException("Missing HTTP POST request entity body");
        }
        Map<String, List<String>> map = URLUtils.parseParameters(string);
        String string2 = MultivaluedMapUtils.getFirstValue(map, "client_id");
        if (StringUtils.isBlank(string2)) {
            throw new ParseException("Missing client_id parameter");
        }
        if (hTTPRequest.getClientX509Certificate() == null) {
            throw new ParseException("Missing client X.509 certificate");
        }
        return new PKITLSClientAuthentication(new ClientID(string2), hTTPRequest.getClientX509Certificate());
    }
}

