/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class ClientSecretPost
extends PlainClientSecret {
    public ClientSecretPost(ClientID clientID, Secret secret) {
        super(ClientAuthenticationMethod.CLIENT_SECRET_POST, clientID, secret);
    }

    @Override
    public Set<String> getFormParameterNames() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("client_id", "client_secret")));
    }

    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        hashMap.put("client_secret", Collections.singletonList(this.getClientSecret().getValue()));
        return hashMap;
    }

    @Override
    public void applyTo(HTTPRequest hTTPRequest) {
        if (hTTPRequest.getMethod() != HTTPRequest.Method.POST) {
            throw new SerializeException("The HTTP request method must be POST");
        }
        ContentType contentType = hTTPRequest.getEntityContentType();
        if (contentType == null) {
            throw new SerializeException("Missing HTTP Content-Type header");
        }
        if (!contentType.matches(ContentType.APPLICATION_URLENCODED)) {
            throw new SerializeException("The HTTP Content-Type header must be " + ContentType.APPLICATION_URLENCODED);
        }
        Map<String, List<String>> map = hTTPRequest.getQueryParameters();
        map.putAll(this.toParameters());
        String string = URLUtils.serializeParameters(map);
        hTTPRequest.setQuery(string);
    }

    public static ClientSecretPost parse(Map<String, List<String>> map) throws ParseException {
        String string = MultivaluedMapUtils.getFirstValue(map, "client_id");
        if (string == null) {
            throw new ParseException("Malformed client secret post authentication: Missing client_id parameter");
        }
        String string2 = MultivaluedMapUtils.getFirstValue(map, "client_secret");
        if (string2 == null) {
            throw new ParseException("Malformed client secret post authentication: Missing client_secret parameter");
        }
        return new ClientSecretPost(new ClientID(string), new Secret(string2));
    }

    public static ClientSecretPost parse(String string) throws ParseException {
        Map<String, List<String>> map = URLUtils.parseParameters(string);
        return ClientSecretPost.parse(map);
    }

    public static ClientSecretPost parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        return ClientSecretPost.parse(hTTPRequest.getQueryParameters());
    }
}

