/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AssertionGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class SAML2BearerGrant
extends AssertionGrant {
    public static final GrantType GRANT_TYPE = GrantType.SAML2_BEARER;
    private final Base64URL assertion;

    public SAML2BearerGrant(Base64URL base64URL) {
        super(GRANT_TYPE);
        if (base64URL == null) {
            throw new IllegalArgumentException("The SAML 2.0 bearer assertion must not be null");
        }
        this.assertion = base64URL;
    }

    public Base64URL getSAML2Assertion() {
        return this.assertion;
    }

    @Override
    public String getAssertion() {
        return this.assertion.toString();
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("grant_type", Collections.singletonList(GRANT_TYPE.getValue()));
        linkedHashMap.put("assertion", Collections.singletonList(this.assertion.toString()));
        return linkedHashMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SAML2BearerGrant sAML2BearerGrant = (SAML2BearerGrant)object;
        return this.assertion.equals(sAML2BearerGrant.assertion);
    }

    public int hashCode() {
        return this.assertion.hashCode();
    }

    public static SAML2BearerGrant parse(Map<String, List<String>> map) throws ParseException {
        GrantType.ensure(GRANT_TYPE, map);
        String string = MultivaluedMapUtils.getFirstValue(map, "assertion");
        if (string == null || string.trim().isEmpty()) {
            throw MISSING_ASSERTION_PARAM_EXCEPTION;
        }
        return new SAML2BearerGrant(new Base64URL(string));
    }
}

