/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.PushedAuthorizationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class PushedAuthorizationSuccessResponse
extends PushedAuthorizationResponse {
    private final URI requestURI;
    private final long lifetime;

    public PushedAuthorizationSuccessResponse(URI uRI, long l2) {
        if (uRI == null) {
            throw new IllegalArgumentException("The request URI must not be null");
        }
        this.requestURI = uRI;
        if (l2 <= 0L) {
            throw new IllegalArgumentException("The request lifetime must be a positive integer");
        }
        this.lifetime = l2;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("request_uri", this.getRequestURI().toString());
        jSONObject.put("expires_in", this.getLifetime());
        return jSONObject;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = new HTTPResponse(201);
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        hTTPResponse.setContent(this.toJSONObject().toString());
        return hTTPResponse;
    }

    public static PushedAuthorizationSuccessResponse parse(JSONObject jSONObject) throws ParseException {
        URI uRI = JSONObjectUtils.getURI(jSONObject, "request_uri");
        long l2 = JSONObjectUtils.getLong(jSONObject, "expires_in");
        return new PushedAuthorizationSuccessResponse(uRI, l2);
    }

    public static PushedAuthorizationSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCode(201, 200);
        JSONObject jSONObject = hTTPResponse.getContentAsJSONObject();
        return PushedAuthorizationSuccessResponse.parse(jSONObject);
    }
}

