/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.PushedAuthorizationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class PushedAuthorizationErrorResponse
extends PushedAuthorizationResponse
implements ErrorResponse {
    private final ErrorObject error;

    public PushedAuthorizationErrorResponse(ErrorObject errorObject) {
        if (errorObject == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = errorObject;
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        return this.getErrorObject().toHTTPResponse();
    }

    public static PushedAuthorizationErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        int n2 = hTTPResponse.getStatusCode();
        if (n2 == 201 || n2 == 200) {
            throw new ParseException("The HTTP status code must be other than 201 and 200");
        }
        ErrorObject errorObject = hTTPResponse.getEntityContentType() != null && ContentType.APPLICATION_JSON.matches(hTTPResponse.getEntityContentType()) ? ErrorObject.parse(hTTPResponse.getContentAsJSONObject()) : new ErrorObject(null);
        return new PushedAuthorizationErrorResponse(errorObject.setHTTPStatusCode(n2));
    }
}

