/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.State;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class AuthorizationErrorResponse
extends AuthorizationResponse
implements ErrorResponse {
    private static final Set<ErrorObject> stdErrors = new HashSet<ErrorObject>();
    private final ErrorObject error;

    public static Set<ErrorObject> getStandardErrors() {
        return Collections.unmodifiableSet(stdErrors);
    }

    public AuthorizationErrorResponse(URI uRI, ErrorObject errorObject, State state, ResponseMode responseMode) {
        this(uRI, errorObject, state, null, responseMode);
    }

    public AuthorizationErrorResponse(URI uRI, ErrorObject errorObject, State state, Issuer issuer, ResponseMode responseMode) {
        super(uRI, state, issuer, responseMode);
        if (errorObject == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = errorObject;
    }

    public AuthorizationErrorResponse(URI uRI, JWT jWT, ResponseMode responseMode) {
        super(uRI, jWT, responseMode);
        this.error = null;
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    @Override
    public ResponseMode impliedResponseMode() {
        return this.getResponseMode() != null ? this.getResponseMode() : ResponseMode.QUERY;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (this.getJWTResponse() != null) {
            hashMap.put("response", Collections.singletonList(this.getJWTResponse().serialize()));
            return hashMap;
        }
        hashMap.putAll(this.getErrorObject().toParameters());
        if (this.getState() != null) {
            hashMap.put("state", Collections.singletonList(this.getState().getValue()));
        }
        if (this.getIssuer() != null) {
            hashMap.put("iss", Collections.singletonList(this.getIssuer().getValue()));
        }
        return hashMap;
    }

    public static AuthorizationErrorResponse parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        String string = MultivaluedMapUtils.getFirstValue(map, "response");
        if (string != null) {
            JWT jWT;
            try {
                jWT = JWTParser.parse(string);
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid JWT response: " + parseException.getMessage(), parseException);
            }
            return new AuthorizationErrorResponse(uRI, jWT, ResponseMode.JWT);
        }
        ErrorObject errorObject = ErrorObject.parse(map);
        if (StringUtils.isBlank(errorObject.getCode())) {
            throw new ParseException("Missing error code");
        }
        errorObject = errorObject.setHTTPStatusCode(302);
        State state = State.parse(MultivaluedMapUtils.getFirstValue(map, "state"));
        Issuer issuer = Issuer.parse(MultivaluedMapUtils.getFirstValue(map, "iss"));
        return new AuthorizationErrorResponse(uRI, errorObject, state, issuer, null);
    }

    public static AuthorizationErrorResponse parse(URI uRI) throws ParseException {
        return AuthorizationErrorResponse.parse(URIUtils.getBaseURI(uRI), AuthorizationErrorResponse.parseResponseParameters(uRI));
    }

    public static AuthorizationErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URL / HTTP Location header");
        }
        return AuthorizationErrorResponse.parse(uRI);
    }

    public static AuthorizationErrorResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthorizationErrorResponse.parse(hTTPRequest.getURI(), AuthorizationErrorResponse.parseResponseParameters(hTTPRequest));
    }

    static {
        stdErrors.add(OAuth2Error.INVALID_REQUEST);
        stdErrors.add(OAuth2Error.UNAUTHORIZED_CLIENT);
        stdErrors.add(OAuth2Error.ACCESS_DENIED);
        stdErrors.add(OAuth2Error.UNSUPPORTED_RESPONSE_TYPE);
        stdErrors.add(OAuth2Error.INVALID_SCOPE);
        stdErrors.add(OAuth2Error.SERVER_ERROR);
        stdErrors.add(OAuth2Error.TEMPORARILY_UNAVAILABLE);
    }
}

