/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SuccessResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.TokenResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.Tokens;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class AccessTokenResponse
extends TokenResponse
implements SuccessResponse {
    private final Tokens tokens;
    private final Map<String, Object> customParams;

    public AccessTokenResponse(Tokens tokens) {
        this(tokens, null);
    }

    public AccessTokenResponse(Tokens tokens, Map<String, Object> map) {
        if (tokens == null) {
            throw new IllegalArgumentException("The tokens must not be null");
        }
        this.tokens = tokens;
        this.customParams = map;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public Tokens getTokens() {
        return this.tokens;
    }

    public Map<String, Object> getCustomParameters() {
        if (this.customParams == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customParams);
    }

    @Deprecated
    public Map<String, Object> getCustomParams() {
        return this.getCustomParameters();
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = this.tokens.toJSONObject();
        if (this.customParams != null) {
            jSONObject.putAll(this.customParams);
        }
        return jSONObject;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = new HTTPResponse(200);
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        hTTPResponse.setContent(this.toJSONObject().toString());
        return hTTPResponse;
    }

    public static AccessTokenResponse parse(JSONObject jSONObject) throws ParseException {
        Tokens tokens = Tokens.parse(jSONObject);
        HashSet hashSet = new HashSet(jSONObject.keySet());
        hashSet.removeAll(tokens.getParameterNames());
        HashMap<String, Object> hashMap = null;
        if (!hashSet.isEmpty()) {
            hashMap = new HashMap<String, Object>();
            for (String string : hashSet) {
                hashMap.put(string, jSONObject.get(string));
            }
        }
        return new AccessTokenResponse(tokens, hashMap);
    }

    public static AccessTokenResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCode(200);
        JSONObject jSONObject = hTTPResponse.getContentAsJSONObject();
        return AccessTokenResponse.parse(jSONObject);
    }
}

