/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagException;

public final class LangTagUtils {
    public static String strip(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(35);
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static Set<String> strip(Set<String> set) {
        if (set == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            hashSet.add(LangTagUtils.strip(string));
        }
        return hashSet;
    }

    public static List<String> strip(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(LangTagUtils.strip(string));
        }
        return arrayList;
    }

    public static LangTag extract(String string) throws LangTagException {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(35);
        if (n2 < 0 || string.length() < n2 + 1) {
            return null;
        }
        return LangTag.parse(string.substring(n2 + 1));
    }

    public static <T> Map<LangTag, T> find(String string, Map<String, T> map) {
        HashMap<LangTag, T> hashMap = new HashMap<LangTag, T>();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            T t2;
            try {
                t2 = entry.getValue();
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (entry.getKey().equals(string)) {
                hashMap.put(null, t2);
                continue;
            }
            if (!entry.getKey().startsWith(string + '#')) continue;
            String[] stringArray = entry.getKey().split("#", 2);
            LangTag langTag = null;
            if (stringArray.length == 2) {
                try {
                    langTag = LangTag.parse(stringArray[1]);
                }
                catch (LangTagException langTagException) {
                    // empty catch block
                }
            }
            hashMap.put(langTag, t2);
        }
        return hashMap;
    }

    public static List<String> toStringList(Collection<LangTag> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (LangTag langTag : collection) {
            arrayList.add(langTag.toString());
        }
        return arrayList;
    }

    public static String[] toStringArray(Collection<LangTag> collection) {
        if (collection == null) {
            return null;
        }
        String[] stringArray = new String[collection.size()];
        int n2 = 0;
        for (LangTag langTag : collection) {
            stringArray[n2++] = langTag.toString();
        }
        return stringArray;
    }

    public static List<LangTag> parseLangTagList(Collection<String> collection) throws LangTagException {
        if (collection == null) {
            return null;
        }
        ArrayList<LangTag> arrayList = new ArrayList<LangTag>(collection.size());
        for (String string : collection) {
            arrayList.add(LangTag.parse(string));
        }
        return arrayList;
    }

    public static List<LangTag> parseLangTagList(String ... stringArray) throws LangTagException {
        if (stringArray == null) {
            return null;
        }
        ArrayList<LangTag> arrayList = new ArrayList<LangTag>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(LangTag.parse(string));
        }
        return arrayList;
    }

    public static LangTag[] parseLangTagArray(String ... stringArray) throws LangTagException {
        if (stringArray == null) {
            return null;
        }
        LangTag[] langTagArray = new LangTag[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            langTagArray[i2] = LangTag.parse(stringArray[i2]);
        }
        return langTagArray;
    }

    public static Map.Entry<String, LangTag> split(String string) throws LangTagException {
        if (string == null) {
            return null;
        }
        if ("#".equals(string)) {
            return new AbstractMap.SimpleImmutableEntry<String, Object>("#", null);
        }
        int n2 = string.indexOf(35);
        if (n2 < 0 || string.length() < n2 + 1) {
            return new AbstractMap.SimpleImmutableEntry<String, Object>(string, null);
        }
        return new AbstractMap.SimpleImmutableEntry<String, LangTag>(string.substring(0, n2), LangTag.parse(string.substring(n2 + 1)));
    }

    public static String concat(List<LangTag> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (LangTag langTag : list) {
            if (langTag == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(langTag);
        }
        return stringBuilder.toString();
    }

    private LangTagUtils() {
    }
}

