/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt;

import java.text.ParseException;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SignedJWT
extends JWSObject
implements JWT {
    private static final long serialVersionUID = 1L;
    private JWTClaimsSet claimsSet;

    public SignedJWT(JWSHeader jWSHeader, JWTClaimsSet jWTClaimsSet) {
        super(jWSHeader, jWTClaimsSet.toPayload());
        this.claimsSet = jWTClaimsSet;
    }

    public SignedJWT(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3) throws ParseException {
        super(base64URL, base64URL2, base64URL3);
    }

    @Override
    public JWTClaimsSet getJWTClaimsSet() throws ParseException {
        if (this.claimsSet != null) {
            return this.claimsSet;
        }
        Map<String, Object> map = this.getPayload().toJSONObject();
        if (map == null) {
            throw new ParseException("Payload of JWS object is not a valid JSON object", 0);
        }
        this.claimsSet = JWTClaimsSet.parse(map);
        return this.claimsSet;
    }

    @Override
    protected void setPayload(Payload payload) {
        this.claimsSet = null;
        super.setPayload(payload);
    }

    public static SignedJWT parse(String string) throws ParseException {
        Base64URL[] base64URLArray = JOSEObject.split(string);
        if (base64URLArray.length != 3) {
            throw new ParseException("Unexpected number of Base64URL parts, must be three", 0);
        }
        return new SignedJWT(base64URLArray[0], base64URLArray[1], base64URLArray[2]);
    }
}

