/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.AbstractRestrictedResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.BoundedInputStream;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.IOUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Resource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.RestrictedResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultResourceRetriever
extends AbstractRestrictedResourceRetriever
implements RestrictedResourceRetriever {
    private boolean disconnectAfterUse;
    private final SSLSocketFactory sslSocketFactory;
    private Proxy proxy;

    public DefaultResourceRetriever() {
        this(0, 0);
    }

    public DefaultResourceRetriever(int n2, int n3) {
        this(n2, n3, 0);
    }

    public DefaultResourceRetriever(int n2, int n3, int n4) {
        this(n2, n3, n4, true);
    }

    public DefaultResourceRetriever(int n2, int n3, int n4, boolean bl2) {
        this(n2, n3, n4, bl2, null);
    }

    public DefaultResourceRetriever(int n2, int n3, int n4, boolean bl2, SSLSocketFactory sSLSocketFactory) {
        super(n2, n3, n4);
        this.disconnectAfterUse = bl2;
        this.sslSocketFactory = sSLSocketFactory;
    }

    public boolean disconnectsAfterUse() {
        return this.disconnectAfterUse;
    }

    public void setDisconnectsAfterUse(boolean bl2) {
        this.disconnectAfterUse = bl2;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Resource retrieveResource(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            String string;
            Object object2;
            httpURLConnection = this.openConnection(uRL);
            httpURLConnection.setConnectTimeout(this.getConnectTimeout());
            httpURLConnection.setReadTimeout(this.getReadTimeout());
            if (this.sslSocketFactory != null && httpURLConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.getHeaders() != null && !this.getHeaders().isEmpty()) {
                for (Map.Entry object22 : this.getHeaders().entrySet()) {
                    for (Object object2 : (List)object22.getValue()) {
                        httpURLConnection.addRequestProperty((String)object22.getKey(), (String)object2);
                    }
                }
            }
            try (InputStream n2 = this.getInputStream(httpURLConnection, this.getSizeLimit());){
                string = IOUtils.readInputStreamToString(n2, StandardCharset.UTF_8);
            }
            int n2 = httpURLConnection.getResponseCode();
            String string2 = httpURLConnection.getResponseMessage();
            if (n2 > 299 || n2 < 200) {
                throw new IOException("HTTP " + n2 + ": " + (String)string2);
            }
            object2 = new Resource(string, httpURLConnection.getContentType());
            return object2;
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Couldn't open HTTP(S) connection: " + classCastException.getMessage(), classCastException);
        }
        finally {
            if (this.disconnectAfterUse && httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    protected HttpURLConnection openConnection(URL uRL) throws IOException {
        if (this.proxy != null) {
            return (HttpURLConnection)uRL.openConnection(this.proxy);
        }
        return (HttpURLConnection)uRL.openConnection();
    }

    private InputStream getInputStream(HttpURLConnection httpURLConnection, int n2) throws IOException {
        InputStream inputStream = httpURLConnection.getInputStream();
        return n2 > 0 ? new BoundedInputStream(inputStream, this.getSizeLimit()) : inputStream;
    }
}

