/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm.AnnotationVisitor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm.AnnotationWriter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm.Attribute;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm.ByteVector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm.RecordComponentVisitor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm.SymbolTable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm.TypePath;

final class RecordComponentWriter
extends RecordComponentVisitor {
    private final SymbolTable symbolTable;
    private final int nameIndex;
    private final int descriptorIndex;
    private int signatureIndex;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private Attribute firstAttribute;

    RecordComponentWriter(SymbolTable symbolTable, String string, String string2, String string3) {
        super(589824);
        this.symbolTable = symbolTable;
        this.nameIndex = symbolTable.addConstantUtf8(string);
        this.descriptorIndex = symbolTable.addConstantUtf8(string2);
        if (string3 != null) {
            this.signatureIndex = symbolTable.addConstantUtf8(string3);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        if (bl2) {
            this.lastRuntimeVisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        if (bl2) {
            this.lastRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    @Override
    public void visitEnd() {
    }

    int computeRecordComponentInfoSize() {
        int n2 = 6;
        n2 += Attribute.computeAttributesSize(this.symbolTable, 0, this.signatureIndex);
        n2 += AnnotationWriter.computeAnnotationsSize(this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation);
        if (this.firstAttribute != null) {
            n2 += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        return n2;
    }

    void putRecordComponentInfo(ByteVector byteVector) {
        byteVector.putShort(this.nameIndex).putShort(this.descriptorIndex);
        int n2 = 0;
        if (this.signatureIndex != 0) {
            ++n2;
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++n2;
        }
        if (this.firstAttribute != null) {
            n2 += this.firstAttribute.getAttributeCount();
        }
        byteVector.putShort(n2);
        Attribute.putAttributes(this.symbolTable, 0, this.signatureIndex, byteVector);
        AnnotationWriter.putAnnotations(this.symbolTable, this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation, byteVector);
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, byteVector);
        }
    }

    final void collectAttributePrototypes(Attribute.Set set) {
        set.addAttributes(this.firstAttribute);
    }
}

