/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.asm;

import java.lang.reflect.Field;
import java.util.HashMap;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.asm.Accessor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.asm.BasicFiledFilter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.asm.FieldFilter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm.Label;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm.MethodVisitor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.ow2asm.Type;

public class ASMUtil {
    public static void autoBoxing(MethodVisitor methodVisitor, Class<?> clazz) {
        ASMUtil.autoBoxing(methodVisitor, Type.getType(clazz));
    }

    public static Accessor[] getAccessors(Class<?> clazz, FieldFilter fieldFilter) {
        Class<?> clazz2 = clazz;
        HashMap<String, Accessor> hashMap = new HashMap<String, Accessor>();
        if (fieldFilter == null) {
            fieldFilter = BasicFiledFilter.SINGLETON;
        }
        while (clazz2 != Object.class) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz2.getDeclaredFields()) {
                Accessor accessor;
                String string = field.getName();
                if (hashMap.containsKey(string) || !(accessor = new Accessor(clazz2, field, fieldFilter)).isUsable()) continue;
                hashMap.put(string, accessor);
            }
            clazz2 = clazz2.getSuperclass();
        }
        return hashMap.values().toArray(new Accessor[hashMap.size()]);
    }

    protected static void autoBoxing(MethodVisitor methodVisitor, Type type) {
        switch (type.getSort()) {
            case 1: {
                methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 3: {
                methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case 2: {
                methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case 4: {
                methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case 5: {
                methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 6: {
                methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case 7: {
                methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 8: {
                methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
            }
        }
    }

    protected static void autoUnBoxing1(MethodVisitor methodVisitor, Type type) {
        switch (type.getSort()) {
            case 1: {
                methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
                methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case 3: {
                methodVisitor.visitTypeInsn(192, "java/lang/Byte");
                methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                break;
            }
            case 2: {
                methodVisitor.visitTypeInsn(192, "java/lang/Character");
                methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case 4: {
                methodVisitor.visitTypeInsn(192, "java/lang/Short");
                methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                break;
            }
            case 5: {
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                break;
            }
            case 6: {
                methodVisitor.visitTypeInsn(192, "java/lang/Float");
                methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                break;
            }
            case 7: {
                methodVisitor.visitTypeInsn(192, "java/lang/Long");
                methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                break;
            }
            case 8: {
                methodVisitor.visitTypeInsn(192, "java/lang/Double");
                methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                break;
            }
            case 9: {
                methodVisitor.visitTypeInsn(192, type.getInternalName());
                break;
            }
            default: {
                methodVisitor.visitTypeInsn(192, type.getInternalName());
            }
        }
    }

    protected static void autoUnBoxing2(MethodVisitor methodVisitor, Type type) {
        switch (type.getSort()) {
            case 1: {
                methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
                methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case 3: {
                methodVisitor.visitTypeInsn(192, "java/lang/Number");
                methodVisitor.visitMethodInsn(182, "java/lang/Number", "byteValue", "()B", false);
                break;
            }
            case 2: {
                methodVisitor.visitTypeInsn(192, "java/lang/Character");
                methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case 4: {
                methodVisitor.visitTypeInsn(192, "java/lang/Number");
                methodVisitor.visitMethodInsn(182, "java/lang/Number", "shortValue", "()S", false);
                break;
            }
            case 5: {
                methodVisitor.visitTypeInsn(192, "java/lang/Number");
                methodVisitor.visitMethodInsn(182, "java/lang/Number", "intValue", "()I", false);
                break;
            }
            case 6: {
                methodVisitor.visitTypeInsn(192, "java/lang/Number");
                methodVisitor.visitMethodInsn(182, "java/lang/Number", "floatValue", "()F", false);
                break;
            }
            case 7: {
                methodVisitor.visitTypeInsn(192, "java/lang/Number");
                methodVisitor.visitMethodInsn(182, "java/lang/Number", "longValue", "()J", false);
                break;
            }
            case 8: {
                methodVisitor.visitTypeInsn(192, "java/lang/Number");
                methodVisitor.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D", false);
                break;
            }
            case 9: {
                methodVisitor.visitTypeInsn(192, type.getInternalName());
                break;
            }
            default: {
                methodVisitor.visitTypeInsn(192, type.getInternalName());
            }
        }
    }

    public static Label[] newLabels(int n2) {
        Label[] labelArray = new Label[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            labelArray[i2] = new Label();
        }
        return labelArray;
    }

    public static String getSetterName(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2 + 3];
        cArray[0] = 115;
        cArray[1] = 101;
        cArray[2] = 116;
        char c2 = string.charAt(0);
        if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 32);
        }
        cArray[3] = c2;
        for (int i2 = 1; i2 < n2; ++i2) {
            cArray[i2 + 3] = string.charAt(i2);
        }
        return new String(cArray);
    }

    public static String getGetterName(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2 + 3];
        cArray[0] = 103;
        cArray[1] = 101;
        cArray[2] = 116;
        char c2 = string.charAt(0);
        if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 32);
        }
        cArray[3] = c2;
        for (int i2 = 1; i2 < n2; ++i2) {
            cArray[i2 + 3] = string.charAt(i2);
        }
        return new String(cArray);
    }

    public static String getIsName(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2 + 2];
        cArray[0] = 105;
        cArray[1] = 115;
        char c2 = string.charAt(0);
        if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 32);
        }
        cArray[2] = c2;
        for (int i2 = 1; i2 < n2; ++i2) {
            cArray[i2 + 2] = string.charAt(i2);
        }
        return new String(cArray);
    }
}

