/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc;

import java.security.Key;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMatcher;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyConverter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.AbstractJWKSelectorWithSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWEDecryptionKeySelector<C extends SecurityContext>
extends AbstractJWKSelectorWithSource<C>
implements JWEKeySelector<C> {
    private final JWEAlgorithm jweAlg;
    private final EncryptionMethod jweEnc;

    public JWEDecryptionKeySelector(JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod, JWKSource<C> jWKSource) {
        super(jWKSource);
        if (jWEAlgorithm == null) {
            throw new IllegalArgumentException("The JWE algorithm must not be null");
        }
        this.jweAlg = jWEAlgorithm;
        if (encryptionMethod == null) {
            throw new IllegalArgumentException("The JWE encryption method must not be null");
        }
        this.jweEnc = encryptionMethod;
    }

    public JWEAlgorithm getExpectedJWEAlgorithm() {
        return this.jweAlg;
    }

    public EncryptionMethod getExpectedJWEEncryptionMethod() {
        return this.jweEnc;
    }

    protected JWKMatcher createJWKMatcher(JWEHeader jWEHeader) {
        if (!this.getExpectedJWEAlgorithm().equals(jWEHeader.getAlgorithm())) {
            return null;
        }
        if (!this.getExpectedJWEEncryptionMethod().equals(jWEHeader.getEncryptionMethod())) {
            return null;
        }
        return JWKMatcher.forJWEHeader(jWEHeader);
    }

    @Override
    public List<Key> selectJWEKeys(JWEHeader jWEHeader, C c2) throws KeySourceException {
        if (!this.jweAlg.equals(jWEHeader.getAlgorithm()) || !this.jweEnc.equals(jWEHeader.getEncryptionMethod())) {
            return Collections.emptyList();
        }
        JWKMatcher jWKMatcher = this.createJWKMatcher(jWEHeader);
        List<JWK> list = this.getJWKSource().get(new JWKSelector(jWKMatcher), c2);
        LinkedList<Key> linkedList = new LinkedList<Key>();
        for (Key key : KeyConverter.toJavaKeys(list)) {
            if (!(key instanceof PrivateKey) && !(key instanceof SecretKey)) continue;
            linkedList.add(key);
        }
        return linkedList;
    }
}

