/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.gen;

import java.security.KeyStore;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;

public abstract class JWKGenerator<T extends JWK> {
    protected KeyUse use;
    protected Set<KeyOperation> ops;
    protected Algorithm alg;
    protected String kid;
    protected boolean x5tKid;
    protected KeyStore keyStore;

    public JWKGenerator<T> keyUse(KeyUse keyUse) {
        this.use = keyUse;
        return this;
    }

    public JWKGenerator<T> keyOperations(Set<KeyOperation> set) {
        this.ops = set;
        return this;
    }

    public JWKGenerator<T> algorithm(Algorithm algorithm) {
        this.alg = algorithm;
        return this;
    }

    public JWKGenerator<T> keyID(String string) {
        this.kid = string;
        return this;
    }

    public JWKGenerator<T> keyIDFromThumbprint(boolean bl2) {
        this.x5tKid = bl2;
        return this;
    }

    public JWKGenerator<T> keyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public abstract T generate() throws JOSEException;
}

