/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.io.Serializable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Requirement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONStringUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class KeyType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Requirement requirement;
    public static final KeyType EC = new KeyType("EC", Requirement.RECOMMENDED);
    public static final KeyType RSA = new KeyType("RSA", Requirement.REQUIRED);
    public static final KeyType OCT = new KeyType("oct", Requirement.OPTIONAL);
    public static final KeyType OKP = new KeyType("OKP", Requirement.OPTIONAL);

    public KeyType(String string, Requirement requirement) {
        if (string == null) {
            throw new IllegalArgumentException("The key type value must not be null");
        }
        this.value = string;
        this.requirement = requirement;
    }

    public String getValue() {
        return this.value;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof KeyType && this.toString().equals(object.toString());
    }

    public String toString() {
        return this.value;
    }

    public String toJSONString() {
        return JSONStringUtils.toJSONString(this.value);
    }

    public static KeyType parse(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The key type to parse must not be null");
        }
        if (string.equals(EC.getValue())) {
            return EC;
        }
        if (string.equals(RSA.getValue())) {
            return RSA;
        }
        if (string.equals(OCT.getValue())) {
            return OCT;
        }
        if (string.equals(OKP.getValue())) {
            return OKP;
        }
        return new KeyType(string, null);
    }

    public static KeyType forAlgorithm(Algorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        if (JWSAlgorithm.Family.RSA.contains(algorithm)) {
            return RSA;
        }
        if (JWSAlgorithm.Family.EC.contains(algorithm)) {
            return EC;
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains(algorithm)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.RSA.contains(algorithm)) {
            return RSA;
        }
        if (JWEAlgorithm.Family.ECDH_ES.contains(algorithm)) {
            return EC;
        }
        if (JWEAlgorithm.DIR.equals(algorithm)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.AES_GCM_KW.contains(algorithm)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.AES_KW.contains(algorithm)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.PBES2.contains(algorithm)) {
            return OCT;
        }
        if (JWSAlgorithm.Family.ED.contains(algorithm)) {
            return OKP;
        }
        return null;
    }
}

