/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.security.Key;
import java.security.KeyPair;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.AsymmetricJWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.SecretJWK;

public class KeyConverter {
    public static List<Key> toJavaKeys(List<JWK> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        LinkedList<Key> linkedList = new LinkedList<Key>();
        for (JWK jWK : list) {
            try {
                if (jWK instanceof AsymmetricJWK) {
                    KeyPair keyPair = ((AsymmetricJWK)((Object)jWK)).toKeyPair();
                    linkedList.add(keyPair.getPublic());
                    if (keyPair.getPrivate() == null) continue;
                    linkedList.add(keyPair.getPrivate());
                    continue;
                }
                if (!(jWK instanceof SecretJWK)) continue;
                linkedList.add(((SecretJWK)((Object)jWK)).toSecretKey());
            }
            catch (JOSEException jOSEException) {}
        }
        return linkedList;
    }
}

