/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.net.URI;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.X509CertChainUtils;

final class JWKMetadata {
    JWKMetadata() {
    }

    static KeyType parseKeyType(Map<String, Object> map) throws ParseException {
        try {
            return KeyType.parse(JSONObjectUtils.getString(map, "kty"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), 0);
        }
    }

    static KeyUse parseKeyUse(Map<String, Object> map) throws ParseException {
        return KeyUse.parse(JSONObjectUtils.getString(map, "use"));
    }

    static Set<KeyOperation> parseKeyOperations(Map<String, Object> map) throws ParseException {
        return KeyOperation.parse(JSONObjectUtils.getStringList(map, "key_ops"));
    }

    static Algorithm parseAlgorithm(Map<String, Object> map) throws ParseException {
        return Algorithm.parse(JSONObjectUtils.getString(map, "alg"));
    }

    static String parseKeyID(Map<String, Object> map) throws ParseException {
        return JSONObjectUtils.getString(map, "kid");
    }

    static URI parseX509CertURL(Map<String, Object> map) throws ParseException {
        return JSONObjectUtils.getURI(map, "x5u");
    }

    static Base64URL parseX509CertThumbprint(Map<String, Object> map) throws ParseException {
        return JSONObjectUtils.getBase64URL(map, "x5t");
    }

    static Base64URL parseX509CertSHA256Thumbprint(Map<String, Object> map) throws ParseException {
        return JSONObjectUtils.getBase64URL(map, "x5t#S256");
    }

    static List<Base64> parseX509CertChain(Map<String, Object> map) throws ParseException {
        List<Base64> list = X509CertChainUtils.toBase64List(JSONObjectUtils.getJSONArray(map, "x5c"));
        if (list == null || !list.isEmpty()) {
            return list;
        }
        return null;
    }
}

