/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.io.Serializable;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECParameterTable;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class Curve
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Curve P_256 = new Curve("P-256", "secp256r1", "1.2.840.10045.3.1.7");
    public static final Curve SECP256K1 = new Curve("secp256k1", "secp256k1", "1.3.132.0.10");
    @Deprecated
    public static final Curve P_256K = new Curve("P-256K", "secp256k1", "1.3.132.0.10");
    public static final Curve P_384 = new Curve("P-384", "secp384r1", "1.3.132.0.34");
    public static final Curve P_521 = new Curve("P-521", "secp521r1", "1.3.132.0.35");
    public static final Curve Ed25519 = new Curve("Ed25519", "Ed25519", null);
    public static final Curve Ed448 = new Curve("Ed448", "Ed448", null);
    public static final Curve X25519 = new Curve("X25519", "X25519", null);
    public static final Curve X448 = new Curve("X448", "X448", null);
    private final String name;
    private final String stdName;
    private final String oid;

    public Curve(String string) {
        this(string, null, null);
    }

    public Curve(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("The JOSE cryptographic curve name must not be null");
        }
        this.name = string;
        this.stdName = string2;
        this.oid = string3;
    }

    public String getName() {
        return this.name;
    }

    public String getStdName() {
        return this.stdName;
    }

    public String getOID() {
        return this.oid;
    }

    public ECParameterSpec toECParameterSpec() {
        return ECParameterTable.get(this);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        return object instanceof Curve && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public static Curve parse(String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("The cryptographic curve string must not be null or empty");
        }
        if (string.equals(P_256.getName())) {
            return P_256;
        }
        if (string.equals(P_256K.getName())) {
            return P_256K;
        }
        if (string.equals(SECP256K1.getName())) {
            return SECP256K1;
        }
        if (string.equals(P_384.getName())) {
            return P_384;
        }
        if (string.equals(P_521.getName())) {
            return P_521;
        }
        if (string.equals(Ed25519.getName())) {
            return Ed25519;
        }
        if (string.equals(Ed448.getName())) {
            return Ed448;
        }
        if (string.equals(X25519.getName())) {
            return X25519;
        }
        if (string.equals(X448.getName())) {
            return X448;
        }
        return new Curve(string);
    }

    public static Curve forStdName(String string) {
        if ("secp256r1".equals(string) || "prime256v1".equals(string)) {
            return P_256;
        }
        if ("secp256k1".equals(string)) {
            return SECP256K1;
        }
        if ("secp384r1".equals(string)) {
            return P_384;
        }
        if ("secp521r1".equals(string)) {
            return P_521;
        }
        if (Ed25519.getStdName().equals(string)) {
            return Ed25519;
        }
        if (Ed448.getStdName().equals(string)) {
            return Ed448;
        }
        if (X25519.getStdName().equals(string)) {
            return X25519;
        }
        if (X448.getStdName().equals(string)) {
            return X448;
        }
        return null;
    }

    public static Curve forOID(String string) {
        if (P_256.getOID().equals(string)) {
            return P_256;
        }
        if (SECP256K1.getOID().equals(string)) {
            return SECP256K1;
        }
        if (P_384.getOID().equals(string)) {
            return P_384;
        }
        if (P_521.getOID().equals(string)) {
            return P_521;
        }
        return null;
    }

    public static Set<Curve> forJWSAlgorithm(JWSAlgorithm jWSAlgorithm) {
        if (JWSAlgorithm.ES256.equals(jWSAlgorithm)) {
            return Collections.singleton(P_256);
        }
        if (JWSAlgorithm.ES256K.equals(jWSAlgorithm)) {
            return Collections.singleton(SECP256K1);
        }
        if (JWSAlgorithm.ES384.equals(jWSAlgorithm)) {
            return Collections.singleton(P_384);
        }
        if (JWSAlgorithm.ES512.equals(jWSAlgorithm)) {
            return Collections.singleton(P_521);
        }
        if (JWSAlgorithm.EdDSA.equals(jWSAlgorithm)) {
            return Collections.unmodifiableSet(new HashSet<Curve>(Arrays.asList(Ed25519, Ed448)));
        }
        return null;
    }

    public static Curve forECParameterSpec(ECParameterSpec eCParameterSpec) {
        return ECParameterTable.get(eCParameterSpec);
    }
}

