/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jca;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;

public final class JCASupport {
    public static boolean isUnlimitedStrength() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") >= 256;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
    }

    public static boolean isSupported(Algorithm algorithm) {
        if (algorithm instanceof JWSAlgorithm) {
            return JCASupport.isSupported((JWSAlgorithm)algorithm);
        }
        if (algorithm instanceof JWEAlgorithm) {
            return JCASupport.isSupported((JWEAlgorithm)algorithm);
        }
        if (algorithm instanceof EncryptionMethod) {
            return JCASupport.isSupported((EncryptionMethod)algorithm);
        }
        throw new IllegalArgumentException("Unexpected algorithm class: " + algorithm.getClass().getCanonicalName());
    }

    public static boolean isSupported(Algorithm algorithm, Provider provider) {
        if (algorithm instanceof JWSAlgorithm) {
            return JCASupport.isSupported((JWSAlgorithm)algorithm, provider);
        }
        if (algorithm instanceof JWEAlgorithm) {
            return JCASupport.isSupported((JWEAlgorithm)algorithm, provider);
        }
        if (algorithm instanceof EncryptionMethod) {
            return JCASupport.isSupported((EncryptionMethod)algorithm, provider);
        }
        throw new IllegalArgumentException("Unexpected algorithm class: " + algorithm.getClass().getCanonicalName());
    }

    public static boolean isSupported(JWSAlgorithm jWSAlgorithm) {
        if (jWSAlgorithm.getName().equals(Algorithm.NONE.getName())) {
            return true;
        }
        for (Provider provider : Security.getProviders()) {
            if (!JCASupport.isSupported(jWSAlgorithm, provider)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(JWSAlgorithm jWSAlgorithm, Provider provider) {
        if (JWSAlgorithm.Family.HMAC_SHA.contains(jWSAlgorithm)) {
            String string;
            if (jWSAlgorithm.equals(JWSAlgorithm.HS256)) {
                string = "HMACSHA256";
            } else if (jWSAlgorithm.equals(JWSAlgorithm.HS384)) {
                string = "HMACSHA384";
            } else if (jWSAlgorithm.equals(JWSAlgorithm.HS512)) {
                string = "HMACSHA512";
            } else {
                return false;
            }
            return provider.getService("KeyGenerator", string) != null;
        }
        if (JWSAlgorithm.Family.RSA.contains(jWSAlgorithm)) {
            String string;
            String string2 = null;
            if (jWSAlgorithm.equals(JWSAlgorithm.RS256)) {
                string = "SHA256withRSA";
            } else if (jWSAlgorithm.equals(JWSAlgorithm.RS384)) {
                string = "SHA384withRSA";
            } else if (jWSAlgorithm.equals(JWSAlgorithm.RS512)) {
                string = "SHA512withRSA";
            } else if (jWSAlgorithm.equals(JWSAlgorithm.PS256)) {
                string = "RSASSA-PSS";
                string2 = "SHA256withRSAandMGF1";
            } else if (jWSAlgorithm.equals(JWSAlgorithm.PS384)) {
                string = "RSASSA-PSS";
                string2 = "SHA384withRSAandMGF1";
            } else if (jWSAlgorithm.equals(JWSAlgorithm.PS512)) {
                string = "RSASSA-PSS";
                string2 = "SHA512withRSAandMGF1";
            } else {
                return false;
            }
            return provider.getService("Signature", string) != null || string2 != null && provider.getService("Signature", string2) != null;
        }
        if (JWSAlgorithm.Family.EC.contains(jWSAlgorithm)) {
            String string;
            if (jWSAlgorithm.equals(JWSAlgorithm.ES256)) {
                string = "SHA256withECDSA";
            } else if (jWSAlgorithm.equals(JWSAlgorithm.ES384)) {
                string = "SHA384withECDSA";
            } else if (jWSAlgorithm.equals(JWSAlgorithm.ES512)) {
                string = "SHA512withECDSA";
            } else {
                return false;
            }
            return provider.getService("Signature", string) != null;
        }
        return false;
    }

    public static boolean isSupported(JWEAlgorithm jWEAlgorithm) {
        for (Provider provider : Security.getProviders()) {
            if (!JCASupport.isSupported(jWEAlgorithm, provider)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(JWEAlgorithm jWEAlgorithm, Provider provider) {
        if (JWEAlgorithm.Family.RSA.contains(jWEAlgorithm)) {
            String string;
            if (jWEAlgorithm.equals(JWEAlgorithm.RSA1_5)) {
                string = "RSA/ECB/PKCS1Padding";
            } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP)) {
                string = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
            } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_256)) {
                string = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
            } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_512)) {
                string = "RSA/ECB/OAEPWithSHA-512AndMGF1Padding";
            } else {
                return false;
            }
            try {
                Cipher.getInstance(string, provider);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
                return false;
            }
            return true;
        }
        if (JWEAlgorithm.Family.AES_KW.contains(jWEAlgorithm)) {
            return provider.getService("Cipher", "AESWrap") != null;
        }
        if (JWEAlgorithm.Family.ECDH_ES.contains(jWEAlgorithm)) {
            return provider.getService("KeyAgreement", "ECDH") != null;
        }
        if (JWEAlgorithm.Family.AES_GCM_KW.contains(jWEAlgorithm)) {
            try {
                Cipher.getInstance("AES/GCM/NoPadding", provider);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
                return false;
            }
            return true;
        }
        if (JWEAlgorithm.Family.PBES2.contains(jWEAlgorithm)) {
            String string = jWEAlgorithm.equals(JWEAlgorithm.PBES2_HS256_A128KW) ? "HmacSHA256" : (jWEAlgorithm.equals(JWEAlgorithm.PBES2_HS384_A192KW) ? "HmacSHA384" : "HmacSHA512");
            return provider.getService("KeyGenerator", string) != null;
        }
        return JWEAlgorithm.DIR.equals(jWEAlgorithm);
    }

    public static boolean isSupported(EncryptionMethod encryptionMethod) {
        for (Provider provider : Security.getProviders()) {
            if (!JCASupport.isSupported(encryptionMethod, provider)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(EncryptionMethod encryptionMethod, Provider provider) {
        if (EncryptionMethod.Family.AES_CBC_HMAC_SHA.contains(encryptionMethod)) {
            try {
                Cipher.getInstance("AES/CBC/PKCS5Padding", provider);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
                return false;
            }
            String string = encryptionMethod.equals(EncryptionMethod.A128CBC_HS256) ? "HmacSHA256" : (encryptionMethod.equals(EncryptionMethod.A192CBC_HS384) ? "HmacSHA384" : "HmacSHA512");
            return provider.getService("KeyGenerator", string) != null;
        }
        if (EncryptionMethod.Family.AES_GCM.contains(encryptionMethod)) {
            try {
                Cipher.getInstance("AES/GCM/NoPadding", provider);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
                return false;
            }
            return true;
        }
        return false;
    }

    private JCASupport() {
    }
}

