/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmParametersHelper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.CipherHelper;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSA_OAEP_SHA2 {
    private static final String RSA_OEAP_256_JCA_ALG = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    private static final String RSA_OEAP_384_JCA_ALG = "RSA/ECB/OAEPWithSHA-384AndMGF1Padding";
    private static final String RSA_OEAP_512_JCA_ALG = "RSA/ECB/OAEPWithSHA-512AndMGF1Padding";
    private static final String SHA_256_JCA_ALG = "SHA-256";
    private static final String SHA_384_JCA_ALG = "SHA-384";
    private static final String SHA_512_JCA_ALG = "SHA-512";

    public static byte[] encryptCEK(RSAPublicKey rSAPublicKey, SecretKey secretKey, int n2, Provider provider) throws JOSEException {
        MGF1ParameterSpec mGF1ParameterSpec;
        String string;
        String string2;
        if (256 == n2) {
            string2 = RSA_OEAP_256_JCA_ALG;
            string = SHA_256_JCA_ALG;
            mGF1ParameterSpec = MGF1ParameterSpec.SHA256;
        } else if (384 == n2) {
            string2 = RSA_OEAP_384_JCA_ALG;
            string = SHA_384_JCA_ALG;
            mGF1ParameterSpec = MGF1ParameterSpec.SHA384;
        } else if (512 == n2) {
            string2 = RSA_OEAP_512_JCA_ALG;
            string = SHA_512_JCA_ALG;
            mGF1ParameterSpec = MGF1ParameterSpec.SHA512;
        } else {
            throw new JOSEException("Unsupported SHA-2 bit size: " + n2);
        }
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParametersHelper.getInstance("OAEP", provider);
            OAEPParameterSpec oAEPParameterSpec = new OAEPParameterSpec(string, "MGF1", mGF1ParameterSpec, PSource.PSpecified.DEFAULT);
            algorithmParameters.init(oAEPParameterSpec);
            Cipher cipher = CipherHelper.getInstance(string2, provider);
            cipher.init(1, (Key)rSAPublicKey, algorithmParameters);
            return cipher.doFinal(secretKey.getEncoded());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new JOSEException("RSA block size exception: The RSA key is too short, use a longer one", illegalBlockSizeException);
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
    }

    public static SecretKey decryptCEK(PrivateKey privateKey, byte[] byArray, int n2, Provider provider) throws JOSEException {
        MGF1ParameterSpec mGF1ParameterSpec;
        String string;
        String string2;
        if (256 == n2) {
            string2 = RSA_OEAP_256_JCA_ALG;
            string = SHA_256_JCA_ALG;
            mGF1ParameterSpec = MGF1ParameterSpec.SHA256;
        } else if (384 == n2) {
            string2 = RSA_OEAP_384_JCA_ALG;
            string = SHA_384_JCA_ALG;
            mGF1ParameterSpec = MGF1ParameterSpec.SHA384;
        } else if (512 == n2) {
            string2 = RSA_OEAP_512_JCA_ALG;
            string = SHA_512_JCA_ALG;
            mGF1ParameterSpec = MGF1ParameterSpec.SHA512;
        } else {
            throw new JOSEException("Unsupported SHA-2 bit size: " + n2);
        }
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParametersHelper.getInstance("OAEP", provider);
            OAEPParameterSpec oAEPParameterSpec = new OAEPParameterSpec(string, "MGF1", mGF1ParameterSpec, PSource.PSpecified.DEFAULT);
            algorithmParameters.init(oAEPParameterSpec);
            Cipher cipher = CipherHelper.getInstance(string2, provider);
            cipher.init(2, (Key)privateKey, algorithmParameters);
            return new SecretKeySpec(cipher.doFinal(byArray), "AES");
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
    }

    private RSA_OAEP_SHA2() {
    }
}

