/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ConcatKDF;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDH;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDHCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.utils.ECChecks;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetKeyPair;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;

public class ECDH1PU {
    public static ECDH.AlgorithmMode resolveAlgorithmMode(JWEAlgorithm jWEAlgorithm) throws JOSEException {
        Objects.requireNonNull(jWEAlgorithm, "The parameter \"alg\" must not be null");
        if (jWEAlgorithm.equals(JWEAlgorithm.ECDH_1PU)) {
            return ECDH.AlgorithmMode.DIRECT;
        }
        if (jWEAlgorithm.equals(JWEAlgorithm.ECDH_1PU_A128KW) || jWEAlgorithm.equals(JWEAlgorithm.ECDH_1PU_A192KW) || jWEAlgorithm.equals(JWEAlgorithm.ECDH_1PU_A256KW)) {
            return ECDH.AlgorithmMode.KW;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(jWEAlgorithm, ECDHCryptoProvider.SUPPORTED_ALGORITHMS));
    }

    public static int sharedKeyLength(JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod) throws JOSEException {
        Objects.requireNonNull(jWEAlgorithm, "The parameter \"alg\" must not be null");
        Objects.requireNonNull(encryptionMethod, "The parameter \"enc\" must not be null");
        if (jWEAlgorithm.equals(JWEAlgorithm.ECDH_1PU)) {
            int n2 = encryptionMethod.cekBitLength();
            if (n2 == 0) {
                throw new JOSEException("Unsupported JWE encryption method " + encryptionMethod);
            }
            return n2;
        }
        if (jWEAlgorithm.equals(JWEAlgorithm.ECDH_1PU_A128KW)) {
            return 128;
        }
        if (jWEAlgorithm.equals(JWEAlgorithm.ECDH_1PU_A192KW)) {
            return 192;
        }
        if (jWEAlgorithm.equals(JWEAlgorithm.ECDH_1PU_A256KW)) {
            return 256;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(jWEAlgorithm, ECDHCryptoProvider.SUPPORTED_ALGORITHMS));
    }

    public static SecretKey deriveSharedKey(JWEHeader jWEHeader, SecretKey secretKey, ConcatKDF concatKDF) throws JOSEException {
        String string;
        Objects.requireNonNull(jWEHeader, "The parameter \"header\" must not be null");
        Objects.requireNonNull(secretKey, "The parameter \"Z\" must not be null");
        Objects.requireNonNull(concatKDF, "The parameter \"concatKDF\" must not be null");
        int n2 = ECDH1PU.sharedKeyLength(jWEHeader.getAlgorithm(), jWEHeader.getEncryptionMethod());
        ECDH.AlgorithmMode algorithmMode = ECDH1PU.resolveAlgorithmMode(jWEHeader.getAlgorithm());
        if (algorithmMode == ECDH.AlgorithmMode.DIRECT) {
            string = jWEHeader.getEncryptionMethod().getName();
        } else if (algorithmMode == ECDH.AlgorithmMode.KW) {
            string = jWEHeader.getAlgorithm().getName();
        } else {
            throw new JOSEException("Unsupported JWE ECDH algorithm mode: " + (Object)((Object)algorithmMode));
        }
        return concatKDF.deriveKey(secretKey, n2, ConcatKDF.encodeDataWithLength(string.getBytes(StandardCharsets.US_ASCII)), ConcatKDF.encodeDataWithLength(jWEHeader.getAgreementPartyUInfo()), ConcatKDF.encodeDataWithLength(jWEHeader.getAgreementPartyVInfo()), ConcatKDF.encodeIntData(n2), ConcatKDF.encodeNoData());
    }

    public static SecretKey deriveSharedKey(JWEHeader jWEHeader, SecretKey secretKey, Base64URL base64URL, ConcatKDF concatKDF) throws JOSEException {
        String string;
        Objects.requireNonNull(jWEHeader, "The parameter \"header\" must not be null");
        Objects.requireNonNull(secretKey, "The parameter \"Z\" must not be null");
        Objects.requireNonNull(base64URL, "The parameter \"tag\" must not be null");
        Objects.requireNonNull(concatKDF, "The parameter \"concatKDF\" must not be null");
        int n2 = ECDH1PU.sharedKeyLength(jWEHeader.getAlgorithm(), jWEHeader.getEncryptionMethod());
        ECDH.AlgorithmMode algorithmMode = ECDH1PU.resolveAlgorithmMode(jWEHeader.getAlgorithm());
        if (algorithmMode == ECDH.AlgorithmMode.DIRECT) {
            string = jWEHeader.getEncryptionMethod().getName();
        } else if (algorithmMode == ECDH.AlgorithmMode.KW) {
            string = jWEHeader.getAlgorithm().getName();
        } else {
            throw new JOSEException("Unsupported JWE ECDH algorithm mode: " + (Object)((Object)algorithmMode));
        }
        return concatKDF.deriveKey(secretKey, n2, ConcatKDF.encodeDataWithLength(string.getBytes(StandardCharsets.US_ASCII)), ConcatKDF.encodeDataWithLength(jWEHeader.getAgreementPartyUInfo()), ConcatKDF.encodeDataWithLength(jWEHeader.getAgreementPartyVInfo()), ConcatKDF.encodeIntData(n2), ConcatKDF.encodeNoData(), ConcatKDF.encodeDataWithLength(base64URL));
    }

    public static SecretKey deriveZ(SecretKey secretKey, SecretKey secretKey2) {
        Objects.requireNonNull(secretKey, "The parameter \"Ze\" must not be null");
        Objects.requireNonNull(secretKey2, "The parameter \"Zs\" must not be null");
        byte[] byArray = ByteUtils.concat(secretKey.getEncoded(), secretKey2.getEncoded());
        return new SecretKeySpec(byArray, 0, byArray.length, "AES");
    }

    public static SecretKey deriveSenderZ(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey2, Provider provider) throws JOSEException {
        ECDH1PU.validateSameCurve(eCPrivateKey, eCPublicKey);
        ECDH1PU.validateSameCurve(eCPrivateKey2, eCPublicKey);
        SecretKey secretKey = ECDH.deriveSharedSecret(eCPublicKey, eCPrivateKey2, provider);
        SecretKey secretKey2 = ECDH.deriveSharedSecret(eCPublicKey, eCPrivateKey, provider);
        return ECDH1PU.deriveZ(secretKey, secretKey2);
    }

    public static SecretKey deriveSenderZ(OctetKeyPair octetKeyPair, OctetKeyPair octetKeyPair2, OctetKeyPair octetKeyPair3) throws JOSEException {
        ECDH1PU.validateSameCurve(octetKeyPair, octetKeyPair2);
        ECDH1PU.validateSameCurve(octetKeyPair3, octetKeyPair2);
        SecretKey secretKey = ECDH.deriveSharedSecret(octetKeyPair2, octetKeyPair3);
        SecretKey secretKey2 = ECDH.deriveSharedSecret(octetKeyPair2, octetKeyPair);
        return ECDH1PU.deriveZ(secretKey, secretKey2);
    }

    public static SecretKey deriveRecipientZ(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey, ECPublicKey eCPublicKey2, Provider provider) throws JOSEException {
        ECDH1PU.validateSameCurve(eCPrivateKey, eCPublicKey);
        ECDH1PU.validateSameCurve(eCPrivateKey, eCPublicKey2);
        SecretKey secretKey = ECDH.deriveSharedSecret(eCPublicKey2, eCPrivateKey, provider);
        SecretKey secretKey2 = ECDH.deriveSharedSecret(eCPublicKey, eCPrivateKey, provider);
        return ECDH1PU.deriveZ(secretKey, secretKey2);
    }

    public static SecretKey deriveRecipientZ(OctetKeyPair octetKeyPair, OctetKeyPair octetKeyPair2, OctetKeyPair octetKeyPair3) throws JOSEException {
        ECDH1PU.validateSameCurve(octetKeyPair, octetKeyPair2);
        ECDH1PU.validateSameCurve(octetKeyPair, octetKeyPair3);
        SecretKey secretKey = ECDH.deriveSharedSecret(octetKeyPair3, octetKeyPair);
        SecretKey secretKey2 = ECDH.deriveSharedSecret(octetKeyPair2, octetKeyPair);
        return ECDH1PU.deriveZ(secretKey, secretKey2);
    }

    public static void validateSameCurve(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) throws JOSEException {
        Objects.requireNonNull(eCPrivateKey, "The parameter \"privateKey\" must not be null");
        Objects.requireNonNull(eCPublicKey, "The parameter \"publicKey\" must not be null");
        if (!eCPrivateKey.getParams().getCurve().equals(eCPublicKey.getParams().getCurve())) {
            throw new JOSEException("Curve of public key does not match curve of private key");
        }
        if (!ECChecks.isPointOnCurve(eCPublicKey, eCPrivateKey)) {
            throw new JOSEException("Invalid public EC key: Point(s) not on the expected curve");
        }
    }

    public static void validateSameCurve(OctetKeyPair octetKeyPair, OctetKeyPair octetKeyPair2) throws JOSEException {
        Objects.requireNonNull(octetKeyPair, "The parameter \"privateKey\" must not be null");
        Objects.requireNonNull(octetKeyPair2, "The parameter \"publicKey\" must not be null");
        if (!octetKeyPair.isPrivate()) {
            throw new JOSEException("OKP private key should be a private key");
        }
        if (octetKeyPair2.isPrivate()) {
            throw new JOSEException("OKP public key should not be a private key");
        }
        if (!octetKeyPair2.getCurve().equals(Curve.X25519)) {
            throw new JOSEException("Only supports OctetKeyPairs with crv=X25519");
        }
        if (!octetKeyPair.getCurve().equals(octetKeyPair2.getCurve())) {
            throw new JOSEException("Curve of public key does not match curve of private key");
        }
    }

    private ECDH1PU() {
    }
}

