/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.util.Collection;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;

public class AlgorithmSupportMessage {
    private static String itemize(Collection collection) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = collection.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 != 0) {
                if (i2 < objectArray.length - 1) {
                    stringBuilder.append(", ");
                } else if (i2 == objectArray.length - 1) {
                    stringBuilder.append(" or ");
                }
            }
            stringBuilder.append(objectArray[i2].toString());
        }
        return stringBuilder.toString();
    }

    public static String unsupportedJWSAlgorithm(JWSAlgorithm jWSAlgorithm, Collection<JWSAlgorithm> collection) {
        return "Unsupported JWS algorithm " + jWSAlgorithm + ", must be " + AlgorithmSupportMessage.itemize(collection);
    }

    public static String unsupportedJWEAlgorithm(JWEAlgorithm jWEAlgorithm, Collection<JWEAlgorithm> collection) {
        return "Unsupported JWE algorithm " + jWEAlgorithm + ", must be " + AlgorithmSupportMessage.itemize(collection);
    }

    public static String unsupportedEncryptionMethod(EncryptionMethod encryptionMethod, Collection<EncryptionMethod> collection) {
        return "Unsupported JWE encryption method " + encryptionMethod + ", must be " + AlgorithmSupportMessage.itemize(collection);
    }

    public static String unsupportedEllipticCurve(Curve curve, Collection<Curve> collection) {
        return "Unsupported elliptic curve " + curve + ", must be " + AlgorithmSupportMessage.itemize(collection);
    }

    private AlgorithmSupportMessage() {
    }
}

