/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.security.Provider;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeyLengthException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESGCM;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Container;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESGCMKW {
    public static AuthenticatedCipherText encryptCEK(SecretKey secretKey, Container<byte[]> container, SecretKey secretKey2, Provider provider) throws JOSEException {
        return AESGCM.encrypt(secretKey2, container, secretKey.getEncoded(), new byte[0], provider);
    }

    public static SecretKey decryptCEK(SecretKey secretKey, byte[] byArray, AuthenticatedCipherText authenticatedCipherText, int n2, Provider provider) throws JOSEException {
        byte[] byArray2 = AESGCM.decrypt(secretKey, byArray, authenticatedCipherText.getCipherText(), new byte[0], authenticatedCipherText.getAuthenticationTag(), provider);
        if (ByteUtils.safeBitLength(byArray2) != n2) {
            throw new KeyLengthException("CEK key length mismatch: " + ByteUtils.safeBitLength(byArray2) + " != " + n2);
        }
        return new SecretKeySpec(byArray2, "AES");
    }

    private AESGCMKW() {
    }
}

