/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import com.google.crypto.tink.subtle.Ed25519Sign;
import java.security.GeneralSecurityException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.EdDSAProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetKeyPair;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class Ed25519Signer
extends EdDSAProvider
implements JWSSigner {
    private final OctetKeyPair privateKey;
    private final Ed25519Sign tinkSigner;

    public Ed25519Signer(OctetKeyPair octetKeyPair) throws JOSEException {
        if (!Curve.Ed25519.equals(octetKeyPair.getCurve())) {
            throw new JOSEException("Ed25519Signer only supports OctetKeyPairs with crv=Ed25519");
        }
        if (!octetKeyPair.isPrivate()) {
            throw new JOSEException("The OctetKeyPair doesn't contain a private part");
        }
        this.privateKey = octetKeyPair;
        try {
            this.tinkSigner = new Ed25519Sign(octetKeyPair.getDecodedD());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Base64URL sign(JWSHeader jWSHeader, byte[] byArray) throws JOSEException {
        byte[] byArray2;
        JWSAlgorithm jWSAlgorithm = jWSHeader.getAlgorithm();
        if (!JWSAlgorithm.EdDSA.equals(jWSAlgorithm)) {
            throw new JOSEException("Ed25519Signer requires alg=EdDSA in JWSHeader");
        }
        try {
            byArray2 = this.tinkSigner.sign(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), generalSecurityException);
        }
        return Base64URL.encode(byArray2);
    }
}

