/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.HeaderValidation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.IllegalHeaderException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectJSON;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.UnprotectedHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWSObjectJSON
extends JOSEObjectJSON {
    private static final long serialVersionUID = 1L;
    private final List<Signature> signatures = new LinkedList<Signature>();

    public JWSObjectJSON(Payload payload) {
        super(payload);
        Objects.requireNonNull(payload, "The payload must not be null");
    }

    private JWSObjectJSON(Payload payload, List<Signature> list) {
        super(payload);
        Objects.requireNonNull(payload, "The payload must not be null");
        if (list.isEmpty()) {
            throw new IllegalArgumentException("At least one signature required");
        }
        this.signatures.addAll(list);
    }

    public List<Signature> getSignatures() {
        return Collections.unmodifiableList(this.signatures);
    }

    public synchronized void sign(JWSHeader jWSHeader, JWSSigner jWSSigner) throws JOSEException {
        this.sign(jWSHeader, null, jWSSigner);
    }

    public synchronized void sign(JWSHeader jWSHeader, UnprotectedHeader unprotectedHeader, JWSSigner jWSSigner) throws JOSEException {
        try {
            HeaderValidation.ensureDisjoint(jWSHeader, unprotectedHeader);
        }
        catch (IllegalHeaderException illegalHeaderException) {
            throw new IllegalArgumentException(illegalHeaderException.getMessage(), illegalHeaderException);
        }
        JWSObject jWSObject = new JWSObject(jWSHeader, this.getPayload());
        jWSObject.sign(jWSSigner);
        this.signatures.add(new Signature(this.getPayload(), jWSHeader, unprotectedHeader, jWSObject.getSignature()));
    }

    public State getState() {
        if (this.getSignatures().isEmpty()) {
            return State.UNSIGNED;
        }
        for (Signature signature : this.getSignatures()) {
            if (signature.isVerified()) continue;
            return State.SIGNED;
        }
        return State.VERIFIED;
    }

    @Override
    public Map<String, Object> toGeneralJSONObject() {
        if (this.signatures.size() < 1) {
            throw new IllegalStateException("The general JWS JSON serialization requires at least one signature");
        }
        Map<String, Object> map = JSONObjectUtils.newJSONObject();
        map.put("payload", this.getPayload().toBase64URL().toString());
        List<Object> list = JSONArrayUtils.newJSONArray();
        for (Signature signature : this.getSignatures()) {
            Map map2 = signature.toJSONObject();
            list.add(map2);
        }
        map.put("signatures", list);
        return map;
    }

    @Override
    public Map<String, Object> toFlattenedJSONObject() {
        if (this.signatures.size() != 1) {
            throw new IllegalStateException("The flattened JWS JSON serialization requires exactly one signature");
        }
        Map<String, Object> map = JSONObjectUtils.newJSONObject();
        map.put("payload", this.getPayload().toBase64URL().toString());
        map.putAll(this.getSignatures().get(0).toJSONObject());
        return map;
    }

    @Override
    public String serializeGeneral() {
        return JSONObjectUtils.toJSONString(this.toGeneralJSONObject());
    }

    @Override
    public String serializeFlattened() {
        return JSONObjectUtils.toJSONString(this.toFlattenedJSONObject());
    }

    private static JWSHeader parseJWSHeader(Map<String, Object> map) throws ParseException {
        Base64URL base64URL = JSONObjectUtils.getBase64URL(map, "protected");
        if (base64URL == null) {
            throw new ParseException("Missing protected header (required by this library)", 0);
        }
        try {
            return JWSHeader.parse(base64URL);
        }
        catch (ParseException parseException) {
            if ("Not a JWS header".equals(parseException.getMessage())) {
                throw new ParseException("Missing JWS \"alg\" parameter in protected header (required by this library)", 0);
            }
            throw parseException;
        }
    }

    public static JWSObjectJSON parse(Map<String, Object> map) throws ParseException {
        Base64URL base64URL = JSONObjectUtils.getBase64URL(map, "payload");
        if (base64URL == null) {
            throw new ParseException("Missing payload", 0);
        }
        Payload payload = new Payload(base64URL);
        Base64URL base64URL2 = JSONObjectUtils.getBase64URL(map, "signature");
        boolean bl2 = base64URL2 != null;
        LinkedList<Signature> linkedList = new LinkedList<Signature>();
        if (bl2) {
            JWSHeader jWSHeader = JWSObjectJSON.parseJWSHeader(map);
            UnprotectedHeader unprotectedHeader = UnprotectedHeader.parse(JSONObjectUtils.getJSONObject(map, "header"));
            if (map.get("signatures") != null) {
                throw new ParseException("The \"signatures\" member must not be present in flattened JWS JSON serialization", 0);
            }
            try {
                HeaderValidation.ensureDisjoint(jWSHeader, unprotectedHeader);
            }
            catch (IllegalHeaderException illegalHeaderException) {
                throw new ParseException(illegalHeaderException.getMessage(), 0);
            }
            linkedList.add(new Signature(payload, jWSHeader, unprotectedHeader, base64URL2));
        } else {
            Map<String, Object>[] mapArray = JSONObjectUtils.getJSONObjectArray(map, "signatures");
            if (mapArray == null || mapArray.length == 0) {
                throw new ParseException("The \"signatures\" member must be present in general JSON Serialization", 0);
            }
            for (Map<String, Object> map2 : mapArray) {
                JWSHeader jWSHeader = JWSObjectJSON.parseJWSHeader(map2);
                UnprotectedHeader unprotectedHeader = UnprotectedHeader.parse(JSONObjectUtils.getJSONObject(map2, "header"));
                try {
                    HeaderValidation.ensureDisjoint(jWSHeader, unprotectedHeader);
                }
                catch (IllegalHeaderException illegalHeaderException) {
                    throw new ParseException(illegalHeaderException.getMessage(), 0);
                }
                Base64URL base64URL3 = JSONObjectUtils.getBase64URL(map2, "signature");
                if (base64URL3 == null) {
                    throw new ParseException("Missing \"signature\" member", 0);
                }
                linkedList.add(new Signature(payload, jWSHeader, unprotectedHeader, base64URL3));
            }
        }
        return new JWSObjectJSON(payload, linkedList);
    }

    public static JWSObjectJSON parse(String string) throws ParseException {
        return JWSObjectJSON.parse(JSONObjectUtils.parse(string));
    }

    public static enum State {
        UNSIGNED,
        SIGNED,
        VERIFIED;

    }

    @Immutable
    public static final class Signature {
        private final Payload payload;
        private final JWSHeader header;
        private final UnprotectedHeader unprotectedHeader;
        private final Base64URL signature;
        private final AtomicBoolean verified = new AtomicBoolean(false);

        private Signature(Payload payload, JWSHeader jWSHeader, UnprotectedHeader unprotectedHeader, Base64URL base64URL) {
            Objects.requireNonNull(payload);
            this.payload = payload;
            this.header = jWSHeader;
            this.unprotectedHeader = unprotectedHeader;
            Objects.requireNonNull(base64URL);
            this.signature = base64URL;
        }

        public JWSHeader getHeader() {
            return this.header;
        }

        public UnprotectedHeader getUnprotectedHeader() {
            return this.unprotectedHeader;
        }

        public Base64URL getSignature() {
            return this.signature;
        }

        private Map<String, Object> toJSONObject() {
            Map<String, Object> map = JSONObjectUtils.newJSONObject();
            if (this.header != null) {
                map.put("protected", this.header.toBase64URL().toString());
            }
            if (this.unprotectedHeader != null && !this.unprotectedHeader.getIncludedParams().isEmpty()) {
                map.put("header", this.unprotectedHeader.toJSONObject());
            }
            map.put("signature", this.signature.toString());
            return map;
        }

        public JWSObject toJWSObject() {
            try {
                return new JWSObject(this.header.toBase64URL(), this.payload.toBase64URL(), this.signature);
            }
            catch (ParseException parseException) {
                throw new IllegalStateException();
            }
        }

        public boolean isVerified() {
            return this.verified.get();
        }

        public synchronized boolean verify(JWSVerifier jWSVerifier) throws JOSEException {
            try {
                this.verified.set(this.toJWSObject().verify(jWSVerifier));
            }
            catch (JOSEException jOSEException) {
                throw jOSEException;
            }
            catch (Exception exception) {
                throw new JOSEException(exception.getMessage(), exception);
            }
            return this.verified.get();
        }
    }
}

