/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.NamespaceContextImpl;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SafeDocumentBuilderFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.WSTrustVersion;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class WSTrustResponse {
    private static final Logger log = LoggerFactory.getLogger(WSTrustResponse.class);
    public static final String SAML1_ASSERTION = "urn:oasis:names:tc:SAML:1.0:assertion";
    private String faultMessage;
    private boolean errorFound;
    private String errorCode;
    private String token;
    private String tokenType;

    private WSTrustResponse() {
    }

    String getFaultMessage() {
        return this.faultMessage;
    }

    boolean isErrorFound() {
        return this.errorFound;
    }

    String getErrorCode() {
        return this.errorCode;
    }

    String getToken() {
        return this.token;
    }

    String getTokenType() {
        return this.tokenType;
    }

    boolean isTokenSaml2() {
        return this.tokenType != null && !SAML1_ASSERTION.equalsIgnoreCase(this.tokenType);
    }

    static WSTrustResponse parse(String string, WSTrustVersion wSTrustVersion) throws Exception {
        WSTrustResponse wSTrustResponse = new WSTrustResponse();
        DocumentBuilderFactory documentBuilderFactory = SafeDocumentBuilderFactory.createInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
        xPath.setNamespaceContext(namespaceContextImpl);
        if (WSTrustResponse.parseError(wSTrustResponse, document, xPath)) {
            if (StringHelper.isBlank(wSTrustResponse.errorCode)) {
                wSTrustResponse.errorCode = "NONE";
            }
            if (StringHelper.isBlank(wSTrustResponse.faultMessage)) {
                wSTrustResponse.faultMessage = "NONE";
            }
            throw new MsalServiceException(String.format("Server returned error in RSTR - ErrorCode: %s. FaultMessage: %s", wSTrustResponse.errorCode, wSTrustResponse.faultMessage.trim()), "wstrust_service_error");
        }
        WSTrustResponse.parseToken(wSTrustResponse, document, xPath, wSTrustVersion);
        return wSTrustResponse;
    }

    private static void parseToken(WSTrustResponse wSTrustResponse, Document document, XPath xPath, WSTrustVersion wSTrustVersion) throws Exception {
        NodeList nodeList = (NodeList)xPath.compile(wSTrustVersion.responseTokenTypePath()).evaluate(document, XPathConstants.NODESET);
        if (nodeList.getLength() == 0) {
            String string = "No TokenType elements found in RSTR";
            log.warn(string);
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            Object object;
            Object object2;
            if (!StringHelper.isBlank(wSTrustResponse.token)) {
                object2 = "Found more than one returned token.  Using the first.";
                log.warn((String)object2);
                break;
            }
            object2 = nodeList.item(i2);
            wSTrustResponse.tokenType = object2.getTextContent();
            if (StringHelper.isBlank(wSTrustResponse.tokenType)) {
                object = "Could not find token type in RSTR token";
                log.warn((String)object);
            }
            if ((object = (NodeList)xPath.compile(wSTrustVersion.responseSecurityTokenPath()).evaluate(object2.getParentNode(), XPathConstants.NODESET)).getLength() > 1) {
                throw new MsalClientException(String.format("Error parsing WSTrustResponse: Found too many RequestedSecurityToken nodes for token type %s", wSTrustResponse.tokenType), "wstrust_invalid_response");
            }
            if (object.getLength() == 0) {
                string = "Unable to find RequestsSecurityToken element associated with TokenType element: " + wSTrustResponse.tokenType;
                log.warn(string);
                continue;
            }
            wSTrustResponse.token = WSTrustResponse.innerXml(object.item(0));
            if (StringHelper.isBlank(wSTrustResponse.token)) {
                string = "Unable to find token associated with TokenType element: " + wSTrustResponse.tokenType;
                log.warn(string);
                continue;
            }
            string = "Found token of type: " + wSTrustResponse.tokenType;
            log.info(string);
        }
        if (StringHelper.isBlank(wSTrustResponse.token)) {
            throw new MsalClientException("Error parsing WSTrustResponse: Unable to find any tokens in RSTR", "wstrust_invalid_response");
        }
    }

    private static boolean parseError(WSTrustResponse wSTrustResponse, Document document, XPath xPath) throws XPathExpressionException {
        NodeList nodeList;
        boolean bl2 = false;
        NodeList nodeList2 = (NodeList)xPath.compile("//s:Envelope/s:Body/s:Fault/s:Reason").evaluate(document, XPathConstants.NODESET);
        if (nodeList2.getLength() > 0) {
            wSTrustResponse.faultMessage = nodeList2.item(0).getTextContent();
            if (!StringHelper.isBlank(wSTrustResponse.faultMessage)) {
                wSTrustResponse.errorFound = true;
            }
        }
        if ((nodeList = (NodeList)xPath.compile("//s:Envelope/s:Body/s:Fault/s:Code/s:Subcode/s:Value").evaluate(document, XPathConstants.NODESET)).getLength() > 1) {
            throw new MsalClientException(String.format("Error parsing WSTrustResponse: Found too many fault code values: %s", nodeList.getLength()), "wstrust_invalid_response");
        }
        if (nodeList.getLength() == 1) {
            wSTrustResponse.errorCode = nodeList.item(0).getChildNodes().item(0).getTextContent();
            wSTrustResponse.errorCode = wSTrustResponse.errorCode.split(":")[1];
            bl2 = true;
        }
        return bl2;
    }

    static String innerXml(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node2 = nodeList.item(i2);
                DOMSource dOMSource = new DOMSource(node2);
                transformer.transform(dOMSource, streamResult);
                stringBuilder.append(stringWriter.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString().trim();
    }
}

