/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.RefreshToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

class TokenResponse
extends OIDCTokenResponse {
    private String scope;
    private String clientInfo;
    private long expiresIn;
    private long extExpiresIn;
    private String foci;
    private long refreshIn;

    TokenResponse(AccessToken accessToken, RefreshToken refreshToken, String string, String string2, String string3, long l2, long l3, String string4, long l4) {
        super(new OIDCTokens(string, accessToken, refreshToken));
        this.scope = string2;
        this.clientInfo = string3;
        this.expiresIn = l2;
        this.extExpiresIn = l3;
        this.refreshIn = l4;
        this.foci = string4;
    }

    static TokenResponse parseHttpResponse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCode(200);
        JSONObject jSONObject = hTTPResponse.getContentAsJSONObject();
        return TokenResponse.parseJsonObject(jSONObject);
    }

    static Long getLongValue(JSONObject jSONObject, String string) throws ParseException {
        Object v2 = jSONObject.get(string);
        if (v2 instanceof Long) {
            return JSONObjectUtils.getLong(jSONObject, string);
        }
        return Long.parseLong(JSONObjectUtils.getString(jSONObject, string));
    }

    static TokenResponse parseJsonObject(JSONObject jSONObject) throws ParseException {
        String string = "";
        if (jSONObject.containsKey("id_token")) {
            string = JSONObjectUtils.getString(jSONObject, "id_token");
        }
        String string2 = null;
        if (jSONObject.containsKey("scope")) {
            string2 = JSONObjectUtils.getString(jSONObject, "scope");
        }
        String string3 = null;
        if (jSONObject.containsKey("client_info")) {
            string3 = JSONObjectUtils.getString(jSONObject, "client_info");
        }
        long l2 = 0L;
        if (jSONObject.containsKey("expires_in")) {
            l2 = TokenResponse.getLongValue(jSONObject, "expires_in");
        }
        long l3 = 0L;
        if (jSONObject.containsKey("ext_expires_in")) {
            l3 = TokenResponse.getLongValue(jSONObject, "ext_expires_in");
        }
        String string4 = null;
        if (jSONObject.containsKey("foci")) {
            string4 = JSONObjectUtils.getString(jSONObject, "foci");
        }
        long l4 = 0L;
        if (jSONObject.containsKey("refresh_in")) {
            l4 = TokenResponse.getLongValue(jSONObject, "refresh_in");
        }
        try {
            AccessToken accessToken = AccessToken.parse(jSONObject);
            RefreshToken refreshToken = RefreshToken.parse(jSONObject);
            return new TokenResponse(accessToken, refreshToken, string, string2, string3, l2, l3, string4, l4);
        }
        catch (ParseException parseException) {
            throw new MsalClientException("Invalid or missing token, could not parse. If using B2C, information on a potential B2C issue and workaround can be found here: https://aka.ms/msal4j-b2c-known-issues", "invalid_json");
        }
        catch (Exception exception) {
            throw new MsalClientException(exception);
        }
    }

    String getScope() {
        return this.scope;
    }

    String getClientInfo() {
        return this.clientInfo;
    }

    long getExpiresIn() {
        return this.expiresIn;
    }

    long getExtExpiresIn() {
        return this.extExpiresIn;
    }

    String getFoci() {
        return this.foci;
    }

    long getRefreshIn() {
        return this.refreshIn;
    }
}

