/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AadInstanceDiscoveryProvider;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AccessTokenCacheEntity;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AccountCacheEntity;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AppMetadataCacheEntity;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Credential;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.CredentialTypeEnum;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAccount;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITokenCache;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITokenCacheAccessContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IUserAssertion;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IdTokenCacheEntity;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OnBehalfOfRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RefreshTokenCacheEntity;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenCacheAccessContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenRequestExecutor;

public class TokenCache
implements ITokenCache {
    protected static final int MIN_ACCESS_TOKEN_EXPIRE_IN_SEC = 300;
    private transient ReadWriteLock lock = new ReentrantReadWriteLock();
    @JsonProperty(value="AccessToken")
    Map<String, AccessTokenCacheEntity> accessTokens = new LinkedHashMap<String, AccessTokenCacheEntity>();
    @JsonProperty(value="RefreshToken")
    Map<String, RefreshTokenCacheEntity> refreshTokens = new LinkedHashMap<String, RefreshTokenCacheEntity>();
    @JsonProperty(value="IdToken")
    Map<String, IdTokenCacheEntity> idTokens = new LinkedHashMap<String, IdTokenCacheEntity>();
    @JsonProperty(value="Account")
    Map<String, AccountCacheEntity> accounts = new LinkedHashMap<String, AccountCacheEntity>();
    @JsonProperty(value="AppMetadata")
    Map<String, AppMetadataCacheEntity> appMetadata = new LinkedHashMap<String, AppMetadataCacheEntity>();
    transient ITokenCacheAccessAspect tokenCacheAccessAspect;
    private transient String serializedCachedSnapshot;

    public TokenCache(ITokenCacheAccessAspect iTokenCacheAccessAspect) {
        this();
        this.tokenCacheAccessAspect = iTokenCacheAccessAspect;
    }

    public TokenCache() {
    }

    @Override
    public void deserialize(String string) {
        if (StringHelper.isBlank(string)) {
            return;
        }
        this.serializedCachedSnapshot = string;
        TokenCache tokenCache = JsonHelper.convertJsonToObject(string, TokenCache.class);
        this.lock.writeLock().lock();
        try {
            this.accounts = tokenCache.accounts;
            this.accessTokens = tokenCache.accessTokens;
            this.refreshTokens = tokenCache.refreshTokens;
            this.idTokens = tokenCache.idTokens;
            this.appMetadata = tokenCache.appMetadata;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static void mergeJsonObjects(JsonNode jsonNode, JsonNode jsonNode2) {
        TokenCache.mergeRemovals(jsonNode, jsonNode2);
        TokenCache.mergeUpdates(jsonNode, jsonNode2);
    }

    private static void mergeUpdates(JsonNode jsonNode, JsonNode jsonNode2) {
        Iterator<String> iterator = jsonNode2.fieldNames();
        while (iterator.hasNext()) {
            String string = iterator.next();
            JsonNode jsonNode3 = jsonNode2.get(string);
            if (!jsonNode.has(string)) {
                if (jsonNode3.isNull() || jsonNode3.isObject() && jsonNode3.size() == 0) continue;
                ((ObjectNode)jsonNode).set(string, jsonNode3);
                continue;
            }
            JsonNode jsonNode4 = jsonNode.get(string);
            if (jsonNode3.isObject()) {
                TokenCache.mergeUpdates(jsonNode4, jsonNode3);
                continue;
            }
            ((ObjectNode)jsonNode).set(string, jsonNode3);
        }
    }

    private static void mergeRemovals(JsonNode jsonNode, JsonNode jsonNode2) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("Account", "AccessToken", "RefreshToken", "IdToken", "AppMetadata"));
        for (String string : hashSet) {
            JsonNode jsonNode3 = jsonNode.get(string);
            JsonNode jsonNode4 = jsonNode2.get(string);
            if (jsonNode3 == null) continue;
            Iterator<Map.Entry<String, JsonNode>> iterator = jsonNode3.fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                String string2 = entry.getKey();
                if (jsonNode4 != null && jsonNode4.has(string2)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public String serialize() {
        this.lock.readLock().lock();
        try {
            if (!StringHelper.isBlank(this.serializedCachedSnapshot)) {
                JsonNode jsonNode = JsonHelper.mapper.readTree(this.serializedCachedSnapshot);
                Object t2 = JsonHelper.mapper.valueToTree(this);
                TokenCache.mergeJsonObjects(jsonNode, t2);
                String string = JsonHelper.mapper.writeValueAsString(jsonNode);
                return string;
            }
            String string = JsonHelper.mapper.writeValueAsString(this);
            return string;
        }
        catch (IOException iOException) {
            throw new MsalClientException(iOException);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveTokens(TokenRequestExecutor tokenRequestExecutor, AuthenticationResult authenticationResult, String string) {
        try (CacheAspect cacheAspect = new CacheAspect(TokenCacheAccessContext.builder().clientId(tokenRequestExecutor.getMsalRequest().application().clientId()).tokenCache(this).hasCacheChanged(true).build());){
            try {
                Object object;
                this.lock.writeLock().lock();
                if (!StringHelper.isBlank(authenticationResult.accessToken())) {
                    object = TokenCache.createAccessTokenCacheEntity(tokenRequestExecutor, authenticationResult, string);
                    this.accessTokens.put(((AccessTokenCacheEntity)object).getKey(), (AccessTokenCacheEntity)object);
                }
                if (!StringHelper.isBlank(authenticationResult.familyId())) {
                    object = TokenCache.createAppMetadataCacheEntity(tokenRequestExecutor, authenticationResult, string);
                    this.appMetadata.put(((AppMetadataCacheEntity)object).getKey(), (AppMetadataCacheEntity)object);
                }
                if (!StringHelper.isBlank(authenticationResult.refreshToken())) {
                    object = TokenCache.createRefreshTokenCacheEntity(tokenRequestExecutor, authenticationResult, string);
                    ((RefreshTokenCacheEntity)object).family_id(authenticationResult.familyId());
                    this.refreshTokens.put(((RefreshTokenCacheEntity)object).getKey(), (RefreshTokenCacheEntity)object);
                }
                if (!StringHelper.isBlank(authenticationResult.idToken())) {
                    object = TokenCache.createIdTokenCacheEntity(tokenRequestExecutor, authenticationResult, string);
                    this.idTokens.put(((IdTokenCacheEntity)object).getKey(), (IdTokenCacheEntity)object);
                    AccountCacheEntity accountCacheEntity = authenticationResult.accountCacheEntity();
                    accountCacheEntity.environment(string);
                    this.accounts.put(accountCacheEntity.getKey(), accountCacheEntity);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private static RefreshTokenCacheEntity createRefreshTokenCacheEntity(TokenRequestExecutor tokenRequestExecutor, AuthenticationResult authenticationResult, String string) {
        RefreshTokenCacheEntity refreshTokenCacheEntity = new RefreshTokenCacheEntity();
        refreshTokenCacheEntity.credentialType(CredentialTypeEnum.REFRESH_TOKEN.value());
        if (authenticationResult.account() != null) {
            refreshTokenCacheEntity.homeAccountId(authenticationResult.account().homeAccountId());
        }
        refreshTokenCacheEntity.environment(string);
        refreshTokenCacheEntity.clientId(tokenRequestExecutor.getMsalRequest().application().clientId());
        refreshTokenCacheEntity.secret(authenticationResult.refreshToken());
        if (tokenRequestExecutor.getMsalRequest() instanceof OnBehalfOfRequest) {
            OnBehalfOfRequest onBehalfOfRequest = (OnBehalfOfRequest)tokenRequestExecutor.getMsalRequest();
            refreshTokenCacheEntity.userAssertionHash(onBehalfOfRequest.parameters.userAssertion().getAssertionHash());
        }
        return refreshTokenCacheEntity;
    }

    private static AccessTokenCacheEntity createAccessTokenCacheEntity(TokenRequestExecutor tokenRequestExecutor, AuthenticationResult authenticationResult, String string) {
        AccessTokenCacheEntity accessTokenCacheEntity = new AccessTokenCacheEntity();
        accessTokenCacheEntity.credentialType(CredentialTypeEnum.ACCESS_TOKEN.value());
        if (authenticationResult.account() != null) {
            accessTokenCacheEntity.homeAccountId(authenticationResult.account().homeAccountId());
        }
        accessTokenCacheEntity.environment(string);
        accessTokenCacheEntity.clientId(tokenRequestExecutor.getMsalRequest().application().clientId());
        accessTokenCacheEntity.secret(authenticationResult.accessToken());
        accessTokenCacheEntity.realm(tokenRequestExecutor.requestAuthority.tenant());
        String string2 = !StringHelper.isBlank(authenticationResult.scopes()) ? authenticationResult.scopes() : tokenRequestExecutor.getMsalRequest().msalAuthorizationGrant().getScopes();
        accessTokenCacheEntity.target(string2);
        if (tokenRequestExecutor.getMsalRequest() instanceof OnBehalfOfRequest) {
            OnBehalfOfRequest onBehalfOfRequest = (OnBehalfOfRequest)tokenRequestExecutor.getMsalRequest();
            accessTokenCacheEntity.userAssertionHash(onBehalfOfRequest.parameters.userAssertion().getAssertionHash());
        }
        long l2 = System.currentTimeMillis() / 1000L;
        accessTokenCacheEntity.cachedAt(Long.toString(l2));
        accessTokenCacheEntity.expiresOn(Long.toString(authenticationResult.expiresOn()));
        if (authenticationResult.refreshOn() > 0L) {
            accessTokenCacheEntity.refreshOn(Long.toString(authenticationResult.refreshOn()));
        }
        if (authenticationResult.extExpiresOn() > 0L) {
            accessTokenCacheEntity.extExpiresOn(Long.toString(authenticationResult.extExpiresOn()));
        }
        return accessTokenCacheEntity;
    }

    private static IdTokenCacheEntity createIdTokenCacheEntity(TokenRequestExecutor tokenRequestExecutor, AuthenticationResult authenticationResult, String string) {
        IdTokenCacheEntity idTokenCacheEntity = new IdTokenCacheEntity();
        idTokenCacheEntity.credentialType(CredentialTypeEnum.ID_TOKEN.value());
        if (authenticationResult.account() != null) {
            idTokenCacheEntity.homeAccountId(authenticationResult.account().homeAccountId());
        }
        idTokenCacheEntity.environment(string);
        idTokenCacheEntity.clientId(tokenRequestExecutor.getMsalRequest().application().clientId());
        idTokenCacheEntity.secret(authenticationResult.idToken());
        idTokenCacheEntity.realm(tokenRequestExecutor.requestAuthority.tenant());
        if (tokenRequestExecutor.getMsalRequest() instanceof OnBehalfOfRequest) {
            OnBehalfOfRequest onBehalfOfRequest = (OnBehalfOfRequest)tokenRequestExecutor.getMsalRequest();
            idTokenCacheEntity.userAssertionHash(onBehalfOfRequest.parameters.userAssertion().getAssertionHash());
        }
        return idTokenCacheEntity;
    }

    private static AppMetadataCacheEntity createAppMetadataCacheEntity(TokenRequestExecutor tokenRequestExecutor, AuthenticationResult authenticationResult, String string) {
        AppMetadataCacheEntity appMetadataCacheEntity = new AppMetadataCacheEntity();
        appMetadataCacheEntity.clientId(tokenRequestExecutor.getMsalRequest().application().clientId());
        appMetadataCacheEntity.environment(string);
        appMetadataCacheEntity.familyId(authenticationResult.familyId());
        return appMetadataCacheEntity;
    }

    /*
     * Exception decompiling
     */
    Set<IAccount> getAccounts(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getIdTokenKey(String string, String string2, String string3, String string4) {
        return String.join((CharSequence)"-", Arrays.asList(string, string2, "idtoken", string3, string4, "")).toLowerCase();
    }

    private String getApplicationFamilyId(String string, Set<String> set) {
        for (AppMetadataCacheEntity appMetadataCacheEntity : this.appMetadata.values()) {
            if (!appMetadataCacheEntity.clientId().equals(string) || !set.contains(appMetadataCacheEntity.environment()) || StringHelper.isBlank(appMetadataCacheEntity.familyId())) continue;
            return appMetadataCacheEntity.familyId();
        }
        return null;
    }

    private Set<String> getFamilyClientIds(String string, Set<String> set) {
        return this.appMetadata.values().stream().filter(appMetadataCacheEntity -> set.contains(appMetadataCacheEntity.environment()) && string.equals(appMetadataCacheEntity.familyId())).map(AppMetadataCacheEntity::clientId).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAccount(String string, IAccount iAccount) {
        try (CacheAspect cacheAspect = new CacheAspect(TokenCacheAccessContext.builder().clientId(string).tokenCache(this).hasCacheChanged(true).build());){
            try {
                this.lock.writeLock().lock();
                this.removeAccount(iAccount);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private void removeAccount(IAccount iAccount) {
        Predicate<Map.Entry> predicate = entry -> !StringHelper.isBlank(((Credential)entry.getValue()).homeAccountId()) && !StringHelper.isBlank(((Credential)entry.getValue()).environment()) && ((Credential)entry.getValue()).homeAccountId().equals(iAccount.homeAccountId());
        this.accessTokens.entrySet().removeIf(predicate);
        this.refreshTokens.entrySet().removeIf(predicate);
        this.idTokens.entrySet().removeIf(predicate);
        this.accounts.entrySet().removeIf(entry -> !StringHelper.isBlank(((AccountCacheEntity)entry.getValue()).homeAccountId()) && !StringHelper.isBlank(((AccountCacheEntity)entry.getValue()).environment()) && ((AccountCacheEntity)entry.getValue()).homeAccountId().equals(iAccount.homeAccountId()));
    }

    private boolean isMatchingScopes(AccessTokenCacheEntity accessTokenCacheEntity, Set<String> set) {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(Arrays.asList(accessTokenCacheEntity.target().split(" ")));
        return treeSet.containsAll(set);
    }

    private boolean userAssertionHashMatches(Credential credential, String string) {
        if (string == null) {
            return true;
        }
        return credential.userAssertionHash() != null && credential.userAssertionHash().equalsIgnoreCase(string);
    }

    private boolean userAssertionHashMatches(AccountCacheEntity accountCacheEntity, String string) {
        if (string == null) {
            return true;
        }
        return accountCacheEntity.userAssertionHash() != null && accountCacheEntity.userAssertionHash().equalsIgnoreCase(string);
    }

    private Optional<AccessTokenCacheEntity> getAccessTokenCacheEntity(IAccount iAccount, Authority authority, Set<String> set, String string, Set<String> set2) {
        long l2 = new Date().getTime() / 1000L;
        return this.accessTokens.values().stream().filter(accessTokenCacheEntity -> accessTokenCacheEntity.homeAccountId.equals(iAccount.homeAccountId()) && set2.contains(accessTokenCacheEntity.environment) && Long.parseLong(accessTokenCacheEntity.expiresOn()) > l2 + 300L && accessTokenCacheEntity.realm.equals(authority.tenant()) && accessTokenCacheEntity.clientId.equals(string) && this.isMatchingScopes((AccessTokenCacheEntity)accessTokenCacheEntity, set)).findAny();
    }

    private Optional<AccessTokenCacheEntity> getApplicationAccessTokenCacheEntity(Authority authority, Set<String> set, String string, Set<String> set2, String string2) {
        long l2 = new Date().getTime() / 1000L;
        return this.accessTokens.values().stream().filter(accessTokenCacheEntity -> this.userAssertionHashMatches((Credential)accessTokenCacheEntity, string2) && set2.contains(accessTokenCacheEntity.environment) && Long.parseLong(accessTokenCacheEntity.expiresOn()) > l2 + 300L && accessTokenCacheEntity.realm.equals(authority.tenant()) && accessTokenCacheEntity.clientId.equals(string) && this.isMatchingScopes((AccessTokenCacheEntity)accessTokenCacheEntity, set)).findAny();
    }

    private Optional<IdTokenCacheEntity> getIdTokenCacheEntity(IAccount iAccount, Authority authority, String string, Set<String> set) {
        return this.idTokens.values().stream().filter(idTokenCacheEntity -> idTokenCacheEntity.homeAccountId.equals(iAccount.homeAccountId()) && set.contains(idTokenCacheEntity.environment) && idTokenCacheEntity.realm.equals(authority.tenant()) && idTokenCacheEntity.clientId.equals(string)).findAny();
    }

    private Optional<IdTokenCacheEntity> getIdTokenCacheEntity(Authority authority, String string, Set<String> set, String string2) {
        return this.idTokens.values().stream().filter(idTokenCacheEntity -> this.userAssertionHashMatches((Credential)idTokenCacheEntity, string2) && set.contains(idTokenCacheEntity.environment) && idTokenCacheEntity.realm.equals(authority.tenant()) && idTokenCacheEntity.clientId.equals(string)).findAny();
    }

    private Optional<RefreshTokenCacheEntity> getRefreshTokenCacheEntity(IAccount iAccount, String string, Set<String> set) {
        return this.refreshTokens.values().stream().filter(refreshTokenCacheEntity -> refreshTokenCacheEntity.homeAccountId.equals(iAccount.homeAccountId()) && set.contains(refreshTokenCacheEntity.environment) && refreshTokenCacheEntity.clientId.equals(string)).findAny();
    }

    private Optional<AccountCacheEntity> getAccountCacheEntity(IAccount iAccount, Set<String> set) {
        return this.accounts.values().stream().filter(accountCacheEntity -> accountCacheEntity.homeAccountId.equals(iAccount.homeAccountId()) && set.contains(accountCacheEntity.environment)).findAny();
    }

    private Optional<AccountCacheEntity> getAccountCacheEntity(Set<String> set, String string) {
        return this.accounts.values().stream().filter(accountCacheEntity -> this.userAssertionHashMatches((AccountCacheEntity)accountCacheEntity, string) && set.contains(accountCacheEntity.environment)).findAny();
    }

    private Optional<RefreshTokenCacheEntity> getAnyFamilyRefreshTokenCacheEntity(IAccount iAccount, Set<String> set) {
        return this.refreshTokens.values().stream().filter(refreshTokenCacheEntity -> refreshTokenCacheEntity.homeAccountId.equals(iAccount.homeAccountId()) && set.contains(refreshTokenCacheEntity.environment) && refreshTokenCacheEntity.isFamilyRT()).findAny();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthenticationResult getCachedAuthenticationResult(IAccount iAccount, Authority authority, Set<String> set, String string) {
        AuthenticationResult.AuthenticationResultBuilder authenticationResultBuilder = AuthenticationResult.builder();
        Set<String> set2 = AadInstanceDiscoveryProvider.getAliases(iAccount.environment());
        try (CacheAspect cacheAspect = new CacheAspect(TokenCacheAccessContext.builder().clientId(string).tokenCache(this).account(iAccount).build());){
            try {
                Optional<RefreshTokenCacheEntity> optional;
                this.lock.readLock().lock();
                Optional<AccountCacheEntity> optional2 = this.getAccountCacheEntity(iAccount, set2);
                Optional<AccessTokenCacheEntity> optional3 = this.getAccessTokenCacheEntity(iAccount, authority, set, string, set2);
                Optional<IdTokenCacheEntity> optional4 = this.getIdTokenCacheEntity(iAccount, authority, string, set2);
                if (!StringHelper.isBlank(this.getApplicationFamilyId(string, set2))) {
                    optional = this.getAnyFamilyRefreshTokenCacheEntity(iAccount, set2);
                    if (!optional.isPresent()) {
                        optional = this.getRefreshTokenCacheEntity(iAccount, string, set2);
                    }
                } else {
                    optional = this.getRefreshTokenCacheEntity(iAccount, string, set2);
                    if (!optional.isPresent()) {
                        optional = this.getAnyFamilyRefreshTokenCacheEntity(iAccount, set2);
                    }
                }
                if (optional3.isPresent()) {
                    authenticationResultBuilder.environment(optional3.get().environment).accessToken(optional3.get().secret).expiresOn(Long.parseLong(optional3.get().expiresOn()));
                    if (optional3.get().refreshOn() != null) {
                        authenticationResultBuilder.refreshOn(Long.parseLong(optional3.get().refreshOn()));
                    }
                } else {
                    authenticationResultBuilder.environment(authority.host());
                }
                optional4.ifPresent(idTokenCacheEntity -> authenticationResultBuilder.idToken(idTokenCacheEntity.secret));
                optional.ifPresent(refreshTokenCacheEntity -> authenticationResultBuilder.refreshToken(refreshTokenCacheEntity.secret));
                optional2.ifPresent(authenticationResultBuilder::accountCacheEntity);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return authenticationResultBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthenticationResult getCachedAuthenticationResult(Authority authority, Set<String> set, String string, IUserAssertion iUserAssertion) {
        AuthenticationResult.AuthenticationResultBuilder authenticationResultBuilder = AuthenticationResult.builder();
        Set<String> set2 = AadInstanceDiscoveryProvider.getAliases(authority.host);
        authenticationResultBuilder.environment(authority.host());
        try (CacheAspect cacheAspect = new CacheAspect(TokenCacheAccessContext.builder().clientId(string).tokenCache(this).build());){
            Object object;
            try {
                this.lock.readLock().lock();
                object = iUserAssertion == null ? null : iUserAssertion.getAssertionHash();
                Optional<AccountCacheEntity> optional = this.getAccountCacheEntity(set2, (String)object);
                optional.ifPresent(authenticationResultBuilder::accountCacheEntity);
                Optional<AccessTokenCacheEntity> optional2 = this.getApplicationAccessTokenCacheEntity(authority, set, string, set2, (String)object);
                if (optional2.isPresent()) {
                    authenticationResultBuilder.accessToken(optional2.get().secret).expiresOn(Long.parseLong(optional2.get().expiresOn()));
                    if (optional2.get().refreshOn() != null) {
                        authenticationResultBuilder.refreshOn(Long.parseLong(optional2.get().refreshOn()));
                    }
                }
                Optional<IdTokenCacheEntity> optional3 = this.getIdTokenCacheEntity(authority, string, set2, (String)object);
                optional3.ifPresent(idTokenCacheEntity -> authenticationResultBuilder.idToken(idTokenCacheEntity.secret));
            }
            finally {
                this.lock.readLock().unlock();
            }
            object = authenticationResultBuilder.build();
            return object;
        }
    }

    private class CacheAspect
    implements AutoCloseable {
        ITokenCacheAccessContext context;

        CacheAspect(ITokenCacheAccessContext iTokenCacheAccessContext) {
            if (TokenCache.this.tokenCacheAccessAspect != null) {
                this.context = iTokenCacheAccessContext;
                TokenCache.this.tokenCacheAccessAspect.beforeCacheAccess(iTokenCacheAccessContext);
            }
        }

        @Override
        public void close() {
            if (TokenCache.this.tokenCacheAccessAspect != null) {
                TokenCache.this.tokenCacheAccessAspect.afterCacheAccess(this.context);
            }
        }
    }
}

