/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.UUID;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserIdentifier;

class RequestContext {
    private String telemetryRequestId;
    private String clientId;
    private String correlationId;
    private PublicApi publicApi;
    private String applicationName;
    private String applicationVersion;
    private String authority;
    private IAcquireTokenParameters apiParameters;
    private IClientApplicationBase clientApplication;
    private UserIdentifier userIdentifier;

    public RequestContext(AbstractClientApplicationBase abstractClientApplicationBase, PublicApi publicApi, IAcquireTokenParameters iAcquireTokenParameters) {
        this.clientApplication = abstractClientApplicationBase;
        this.clientId = StringHelper.isBlank(abstractClientApplicationBase.clientId()) ? "unset_client_id" : abstractClientApplicationBase.clientId();
        this.correlationId = StringHelper.isBlank(abstractClientApplicationBase.correlationId()) ? RequestContext.generateNewCorrelationId() : abstractClientApplicationBase.correlationId();
        this.applicationVersion = abstractClientApplicationBase.applicationVersion();
        this.applicationName = abstractClientApplicationBase.applicationName();
        this.publicApi = publicApi;
        this.authority = abstractClientApplicationBase.authority();
        this.apiParameters = iAcquireTokenParameters;
    }

    public RequestContext(AbstractClientApplicationBase abstractClientApplicationBase, PublicApi publicApi, IAcquireTokenParameters iAcquireTokenParameters, UserIdentifier userIdentifier) {
        this(abstractClientApplicationBase, publicApi, iAcquireTokenParameters);
        this.userIdentifier = userIdentifier;
    }

    private static String generateNewCorrelationId() {
        return UUID.randomUUID().toString();
    }

    String telemetryRequestId() {
        return this.telemetryRequestId;
    }

    String clientId() {
        return this.clientId;
    }

    String correlationId() {
        return this.correlationId;
    }

    PublicApi publicApi() {
        return this.publicApi;
    }

    String applicationName() {
        return this.applicationName;
    }

    String applicationVersion() {
        return this.applicationVersion;
    }

    String authority() {
        return this.authority;
    }

    IAcquireTokenParameters apiParameters() {
        return this.apiParameters;
    }

    IClientApplicationBase clientApplication() {
        return this.clientApplication;
    }

    UserIdentifier userIdentifier() {
        return this.userIdentifier;
    }

    RequestContext telemetryRequestId(String string) {
        this.telemetryRequestId = string;
        return this;
    }
}

