/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientAuthenticationPost;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IPublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequestParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserIdentifier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserNamePasswordParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserNamePasswordRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

public class PublicClientApplication
extends AbstractClientApplicationBase
implements IPublicClientApplication {
    private final ClientAuthenticationPost clientAuthentication;

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(UserNamePasswordParameters userNamePasswordParameters) {
        ParameterValidationUtils.validateNotNull("parameters", userNamePasswordParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_BY_USERNAME_PASSWORD, userNamePasswordParameters, UserIdentifier.fromUpn(userNamePasswordParameters.username()));
        UserNamePasswordRequest userNamePasswordRequest = new UserNamePasswordRequest(userNamePasswordParameters, this, requestContext);
        return this.executeRequest(userNamePasswordRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(IntegratedWindowsAuthenticationParameters integratedWindowsAuthenticationParameters) {
        ParameterValidationUtils.validateNotNull("parameters", integratedWindowsAuthenticationParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_BY_INTEGRATED_WINDOWS_AUTH, integratedWindowsAuthenticationParameters, UserIdentifier.fromUpn(integratedWindowsAuthenticationParameters.username()));
        IntegratedWindowsAuthenticationRequest integratedWindowsAuthenticationRequest = new IntegratedWindowsAuthenticationRequest(integratedWindowsAuthenticationParameters, this, requestContext);
        return this.executeRequest(integratedWindowsAuthenticationRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(DeviceCodeFlowParameters deviceCodeFlowParameters) {
        if (!AuthorityType.AAD.equals((Object)this.authenticationAuthority.authorityType()) && !AuthorityType.ADFS.equals((Object)this.authenticationAuthority.authorityType())) {
            throw new IllegalArgumentException("Invalid authority type. Device Flow is only supported by AAD and ADFS authorities");
        }
        ParameterValidationUtils.validateNotNull("parameters", deviceCodeFlowParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_BY_DEVICE_CODE_FLOW, deviceCodeFlowParameters);
        AtomicReference<CompletableFuture<IAuthenticationResult>> atomicReference = new AtomicReference<CompletableFuture<IAuthenticationResult>>();
        DeviceCodeFlowRequest deviceCodeFlowRequest = new DeviceCodeFlowRequest(deviceCodeFlowParameters, atomicReference, this, requestContext);
        CompletableFuture<IAuthenticationResult> completableFuture = this.executeRequest(deviceCodeFlowRequest);
        atomicReference.set(completableFuture);
        return completableFuture;
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(InteractiveRequestParameters interactiveRequestParameters) {
        ParameterValidationUtils.validateNotNull("parameters", interactiveRequestParameters);
        AtomicReference<CompletableFuture<IAuthenticationResult>> atomicReference = new AtomicReference<CompletableFuture<IAuthenticationResult>>();
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_INTERACTIVE, interactiveRequestParameters, UserIdentifier.fromUpn(interactiveRequestParameters.loginHint()));
        InteractiveRequest interactiveRequest = new InteractiveRequest(interactiveRequestParameters, atomicReference, this, requestContext);
        CompletableFuture<IAuthenticationResult> completableFuture = this.executeRequest(interactiveRequest);
        atomicReference.set(completableFuture);
        return completableFuture;
    }

    private PublicClientApplication(Builder builder) {
        super(builder);
        ParameterValidationUtils.validateNotBlank("clientId", this.clientId());
        this.log = LoggerFactory.getLogger(PublicClientApplication.class);
        this.clientAuthentication = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(this.clientId()));
    }

    @Override
    protected ClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public static Builder builder(String string) {
        return new Builder(string);
    }

    public static class Builder
    extends AbstractClientApplicationBase.Builder<Builder> {
        private Builder(String string) {
            super(string);
        }

        @Override
        public PublicClientApplication build() {
            return new PublicClientApplication(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

