/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HTTPContentType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;

class OAuthHttpRequest
extends HTTPRequest {
    private final Map<String, String> extraHeaderParams;
    private final ServiceBundle serviceBundle;
    private final RequestContext requestContext;

    OAuthHttpRequest(HTTPRequest.Method method, URL uRL, Map<String, String> map, RequestContext requestContext, ServiceBundle serviceBundle) {
        super(method, uRL);
        this.extraHeaderParams = map;
        this.requestContext = requestContext;
        this.serviceBundle = serviceBundle;
    }

    @Override
    public HTTPResponse send() throws IOException {
        Map<String, String> map = this.configureHttpHeaders();
        HttpRequest httpRequest = new HttpRequest(HttpMethod.POST, this.getURL().toString(), map, this.getQuery());
        IHttpResponse iHttpResponse = HttpHelper.executeHttpRequest(httpRequest, this.requestContext, this.serviceBundle);
        return this.createOauthHttpResponseFromHttpResponse(iHttpResponse);
    }

    private Map<String, String> configureHttpHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.extraHeaderParams);
        hashMap.put("Content-Type", HTTPContentType.ApplicationURLEncoded.contentType);
        if (this.getAuthorization() != null) {
            hashMap.put("Authorization", this.getAuthorization());
        }
        Map<String, String> map = this.serviceBundle.getServerSideTelemetry().getServerTelemetryHeaderMap();
        hashMap.putAll(map);
        return hashMap;
    }

    private HTTPResponse createOauthHttpResponseFromHttpResponse(IHttpResponse iHttpResponse) throws IOException {
        Object object;
        HTTPResponse hTTPResponse = new HTTPResponse(iHttpResponse.statusCode());
        String string = HttpUtils.headerValue(iHttpResponse.headers(), "Location");
        if (!StringHelper.isBlank(string)) {
            try {
                hTTPResponse.setLocation(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException("Invalid location URI " + string, uRISyntaxException);
            }
        }
        try {
            object = HttpUtils.headerValue(iHttpResponse.headers(), "Content-Type");
            if (!StringHelper.isBlank((String)object)) {
                hTTPResponse.setContentType((String)object);
            }
        }
        catch (ParseException parseException) {
            throw new IOException("Couldn't parse Content-Type header: " + parseException.getMessage(), parseException);
        }
        object = iHttpResponse.headers();
        for (Map.Entry entry : object.entrySet()) {
            String string2;
            if (StringHelper.isBlank((String)entry.getKey()) || (string2 = hTTPResponse.getHeaderValue((String)entry.getKey())) != null && !StringHelper.isBlank(string2)) continue;
            hTTPResponse.setHeader((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
        }
        if (!StringHelper.isBlank(iHttpResponse.body())) {
            hTTPResponse.setContent(iHttpResponse.body());
        }
        return hTTPResponse;
    }

    Map<String, String> getExtraHeaderParams() {
        return this.extraHeaderParams;
    }
}

