/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalInteractionRequiredException;

class InteractionRequiredCache {
    static int DEFAULT_CACHING_TIME_SEC = 120;
    static final int CACHE_SIZE_LIMIT_TO_TRIGGER_EXPIRED_ENTITIES_REMOVAL = 10;
    static Map<String, CachedEntity> requestsToCache = new ConcurrentHashMap<String, CachedEntity>();

    InteractionRequiredCache() {
    }

    static void set(String string, MsalInteractionRequiredException msalInteractionRequiredException) {
        InteractionRequiredCache.removeInvalidCacheEntities();
        long l2 = System.currentTimeMillis();
        requestsToCache.put(string, new CachedEntity(msalInteractionRequiredException, l2 + (long)(DEFAULT_CACHING_TIME_SEC * 1000)));
    }

    static MsalInteractionRequiredException getCachedInteractionRequiredException(String string) {
        InteractionRequiredCache.removeInvalidCacheEntities();
        if (requestsToCache.containsKey(string)) {
            CachedEntity cachedEntity = requestsToCache.get(string);
            if (InteractionRequiredCache.isCacheEntityValid(cachedEntity)) {
                return cachedEntity.exception;
            }
            requestsToCache.remove(string);
        }
        return null;
    }

    private static boolean isCacheEntityValid(CachedEntity cachedEntity) {
        long l2 = cachedEntity.expirationTimestamp;
        long l3 = System.currentTimeMillis();
        return l3 < l2 && l3 >= l2 - (long)(DEFAULT_CACHING_TIME_SEC * 1000);
    }

    private static void removeInvalidCacheEntities() {
        if (requestsToCache.size() > 10) {
            requestsToCache.values().removeIf(cachedEntity -> !InteractionRequiredCache.isCacheEntityValid(cachedEntity));
        }
    }

    static void clear() {
        requestsToCache.clear();
    }

    private static class CachedEntity {
        MsalInteractionRequiredException exception;
        long expirationTimestamp;

        public CachedEntity(MsalInteractionRequiredException msalInteractionRequiredException, long l2) {
            this.exception = msalInteractionRequiredException;
            this.expirationTimestamp = l2;
        }
    }
}

