/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientAssertion;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCertificate;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientSecret;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientAssertion;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientCertificate;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientSecret;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;

public class ClientCredentialFactory {
    public static IClientSecret createFromSecret(String string) {
        return new ClientSecret(string);
    }

    public static IClientCertificate createFromCertificate(InputStream inputStream, String string) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, IOException {
        return ClientCertificate.create(inputStream, string);
    }

    public static IClientCertificate createFromCertificate(PrivateKey privateKey, X509Certificate x509Certificate) {
        ParameterValidationUtils.validateNotNull("publicKeyCertificate", x509Certificate);
        return ClientCertificate.create(privateKey, x509Certificate);
    }

    public static IClientCertificate createFromCertificateChain(PrivateKey privateKey, List<X509Certificate> list) {
        if (privateKey == null || list == null || list.size() == 0) {
            throw new IllegalArgumentException("null or empty input parameter");
        }
        return new ClientCertificate(privateKey, list);
    }

    public static IClientAssertion createFromClientAssertion(String string) {
        return new ClientAssertion(string);
    }

    public static IClientAssertion createFromCallback(Callable<String> callable) throws ExecutionException, InterruptedException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<String> future = executorService.submit(callable);
        return new ClientAssertion(future.get());
    }
}

