/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SystemBrowserOptions;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class AuthorizationResponseHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationResponseHandler.class);
    private static final String DEFAULT_SUCCESS_MESSAGE = "<html><head><title>Authentication Complete</title></head>  <body> Authentication complete. You can close the browser and return to the application.  </body></html>";
    private static final String DEFAULT_FAILURE_MESSAGE = "<html><head><title>Authentication Failed</title></head> <body> Authentication failed. You can return to the application. Feel free to close this browser tab. </br></br></br></br> Error details: error {0} error_description: {1} </body> </html>";
    private BlockingQueue<AuthorizationResult> authorizationResultQueue;
    private SystemBrowserOptions systemBrowserOptions;

    AuthorizationResponseHandler(BlockingQueue<AuthorizationResult> blockingQueue, SystemBrowserOptions systemBrowserOptions) {
        this.authorizationResultQueue = blockingQueue;
        this.systemBrowserOptions = systemBrowserOptions;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            if (!httpExchange.getRequestURI().getPath().equalsIgnoreCase("/")) {
                httpExchange.sendResponseHeaders(200, 0L);
                return;
            }
            String string = new BufferedReader(new InputStreamReader(httpExchange.getRequestBody())).lines().collect(Collectors.joining("\n"));
            AuthorizationResult authorizationResult = AuthorizationResult.fromResponseBody(string);
            this.sendResponse(httpExchange, authorizationResult);
            this.authorizationResultQueue.put(authorizationResult);
        }
        catch (InterruptedException interruptedException) {
            LOG.error("Error reading response from socket: " + interruptedException.getMessage());
            throw new MsalClientException(interruptedException);
        }
        finally {
            httpExchange.close();
        }
    }

    private void sendResponse(HttpExchange httpExchange, AuthorizationResult authorizationResult) throws IOException {
        switch (authorizationResult.status()) {
            case Success: {
                this.sendSuccessResponse(httpExchange, this.getSuccessfulResponseMessage());
                break;
            }
            case ProtocolError: 
            case UnknownError: {
                this.sendErrorResponse(httpExchange, this.getErrorResponseMessage());
            }
        }
    }

    private void sendSuccessResponse(HttpExchange httpExchange, String string) throws IOException {
        if (this.systemBrowserOptions == null || this.systemBrowserOptions.browserRedirectSuccess() == null) {
            this.send200Response(httpExchange, string);
        } else {
            this.send302Response(httpExchange, this.systemBrowserOptions().browserRedirectSuccess().toString());
        }
    }

    private void sendErrorResponse(HttpExchange httpExchange, String string) throws IOException {
        if (this.systemBrowserOptions == null || this.systemBrowserOptions.browserRedirectError() == null) {
            this.send200Response(httpExchange, string);
        } else {
            this.send302Response(httpExchange, this.systemBrowserOptions().browserRedirectError().toString());
        }
    }

    private void send302Response(HttpExchange httpExchange, String string) throws IOException {
        Headers headers = httpExchange.getResponseHeaders();
        headers.set("Location", string);
        httpExchange.sendResponseHeaders(302, 0L);
    }

    private void send200Response(HttpExchange httpExchange, String string) throws IOException {
        httpExchange.sendResponseHeaders(200, string.length());
        OutputStream outputStream = httpExchange.getResponseBody();
        outputStream.write(string.getBytes("UTF-8"));
        outputStream.close();
    }

    private String getSuccessfulResponseMessage() {
        if (this.systemBrowserOptions == null || this.systemBrowserOptions.htmlMessageSuccess() == null) {
            return DEFAULT_SUCCESS_MESSAGE;
        }
        return this.systemBrowserOptions().htmlMessageSuccess();
    }

    private String getErrorResponseMessage() {
        if (this.systemBrowserOptions == null || this.systemBrowserOptions.htmlMessageError() == null) {
            return DEFAULT_FAILURE_MESSAGE;
        }
        return this.systemBrowserOptions().htmlMessageError();
    }

    public BlockingQueue<AuthorizationResult> authorizationResultQueue() {
        return this.authorizationResultQueue;
    }

    public SystemBrowserOptions systemBrowserOptions() {
        return this.systemBrowserOptions;
    }
}

