/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URL;
import java.util.Date;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.CacheTelemetry;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RefreshTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RefreshTokenRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;

class AcquireTokenSilentSupplier
extends AuthenticationResultSupplier {
    private SilentRequest silentRequest;

    AcquireTokenSilentSupplier(AbstractClientApplicationBase abstractClientApplicationBase, SilentRequest silentRequest) {
        super(abstractClientApplicationBase, silentRequest);
        this.silentRequest = silentRequest;
    }

    @Override
    AuthenticationResult execute() throws Exception {
        AuthenticationResult authenticationResult;
        Authority authority = this.silentRequest.requestAuthority();
        if (authority.authorityType != AuthorityType.B2C) {
            authority = this.getAuthorityWithPrefNetworkHost(this.silentRequest.requestAuthority().authority());
        }
        if (this.silentRequest.parameters().account() == null) {
            authenticationResult = this.clientApplication.tokenCache.getCachedAuthenticationResult(authority, this.silentRequest.parameters().scopes(), this.clientApplication.clientId(), this.silentRequest.assertion());
        } else {
            boolean bl2;
            authenticationResult = this.clientApplication.tokenCache.getCachedAuthenticationResult(this.silentRequest.parameters().account(), authority, this.silentRequest.parameters().scopes(), this.clientApplication.clientId());
            if (authenticationResult == null) {
                throw new MsalClientException("Token not found in the cache", "cache_miss");
            }
            if (!StringHelper.isBlank(authenticationResult.accessToken())) {
                this.clientApplication.getServiceBundle().getServerSideTelemetry().incrementSilentSuccessfulCount();
            }
            long l2 = new Date().getTime() / 1000L;
            boolean bl3 = bl2 = authenticationResult.refreshOn() != null && authenticationResult.refreshOn() > 0L && authenticationResult.refreshOn() < l2 && authenticationResult.expiresOn() >= l2;
            if (this.silentRequest.parameters().forceRefresh() || bl2 || StringHelper.isBlank(authenticationResult.accessToken())) {
                if (this.silentRequest.parameters().forceRefresh()) {
                    this.clientApplication.getServiceBundle().getServerSideTelemetry().getCurrentRequest().cacheInfo(CacheTelemetry.REFRESH_FORCE_REFRESH.telemetryValue);
                } else if (bl2) {
                    this.clientApplication.getServiceBundle().getServerSideTelemetry().getCurrentRequest().cacheInfo(CacheTelemetry.REFRESH_REFRESH_IN.telemetryValue);
                } else if (authenticationResult.expiresOn() < l2) {
                    this.clientApplication.getServiceBundle().getServerSideTelemetry().getCurrentRequest().cacheInfo(CacheTelemetry.REFRESH_ACCESS_TOKEN_EXPIRED.telemetryValue);
                } else if (StringHelper.isBlank(authenticationResult.accessToken())) {
                    this.clientApplication.getServiceBundle().getServerSideTelemetry().getCurrentRequest().cacheInfo(CacheTelemetry.REFRESH_NO_ACCESS_TOKEN.telemetryValue);
                }
                if (!StringHelper.isBlank(authenticationResult.refreshToken())) {
                    if (this.silentRequest.parameters().authorityUrl() == null && !authenticationResult.account().environment().equals(authority.host)) {
                        authority = Authority.createAuthority(new URL(authority.authority().replace(authority.host(), authenticationResult.account().environment())));
                    }
                    RefreshTokenRequest refreshTokenRequest = new RefreshTokenRequest(RefreshTokenParameters.builder(this.silentRequest.parameters().scopes(), authenticationResult.refreshToken()).build(), this.silentRequest.application(), this.silentRequest.requestContext(), this.silentRequest);
                    AcquireTokenByAuthorizationGrantSupplier acquireTokenByAuthorizationGrantSupplier = new AcquireTokenByAuthorizationGrantSupplier(this.clientApplication, refreshTokenRequest, authority);
                    try {
                        authenticationResult = acquireTokenByAuthorizationGrantSupplier.execute();
                    }
                    catch (MsalServiceException msalServiceException) {
                        if (bl2 && !this.silentRequest.parameters().forceRefresh() && !StringHelper.isBlank(authenticationResult.accessToken())) {
                            return authenticationResult;
                        }
                        throw msalServiceException;
                    }
                } else {
                    authenticationResult = null;
                }
            }
        }
        if (authenticationResult == null || StringHelper.isBlank(authenticationResult.accessToken())) {
            throw new MsalClientException("Token not found in the cache", "cache_miss");
        }
        return authenticationResult;
    }
}

