/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.google.gson.internal.sql;

import java.sql.Timestamp;
import java.util.Date;
import macromedia.jdbc.sqlserver.externals.com.google.gson.TypeAdapterFactory;
import macromedia.jdbc.sqlserver.externals.com.google.gson.internal.bind.DefaultDateTypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.google.gson.internal.sql.SqlDateTypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.google.gson.internal.sql.SqlTimeTypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.google.gson.internal.sql.SqlTimestampTypeAdapter;

public final class SqlTypesSupport {
    public static final boolean SUPPORTS_SQL_TYPES;
    public static final DefaultDateTypeAdapter.DateType<? extends Date> DATE_DATE_TYPE;
    public static final DefaultDateTypeAdapter.DateType<? extends Date> TIMESTAMP_DATE_TYPE;
    public static final TypeAdapterFactory DATE_FACTORY;
    public static final TypeAdapterFactory TIME_FACTORY;
    public static final TypeAdapterFactory TIMESTAMP_FACTORY;

    private SqlTypesSupport() {
    }

    static {
        boolean bl2;
        try {
            Class.forName("java.sql.Date");
            bl2 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl2 = false;
        }
        SUPPORTS_SQL_TYPES = bl2;
        if (SUPPORTS_SQL_TYPES) {
            DATE_DATE_TYPE = new DefaultDateTypeAdapter.DateType<java.sql.Date>(java.sql.Date.class){

                @Override
                protected java.sql.Date deserialize(Date date) {
                    return new java.sql.Date(date.getTime());
                }
            };
            TIMESTAMP_DATE_TYPE = new DefaultDateTypeAdapter.DateType<Timestamp>(Timestamp.class){

                @Override
                protected Timestamp deserialize(Date date) {
                    return new Timestamp(date.getTime());
                }
            };
            DATE_FACTORY = SqlDateTypeAdapter.FACTORY;
            TIME_FACTORY = SqlTimeTypeAdapter.FACTORY;
            TIMESTAMP_FACTORY = SqlTimestampTypeAdapter.FACTORY;
        } else {
            DATE_DATE_TYPE = null;
            TIMESTAMP_DATE_TYPE = null;
            DATE_FACTORY = null;
            TIME_FACTORY = null;
            TIMESTAMP_FACTORY = null;
        }
    }
}

