/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.google.gson.internal.bind;

import java.io.IOException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.Gson;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonSyntaxException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.ToNumberPolicy;
import macromedia.jdbc.sqlserver.externals.com.google.gson.ToNumberStrategy;
import macromedia.jdbc.sqlserver.externals.com.google.gson.TypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.google.gson.TypeAdapterFactory;
import macromedia.jdbc.sqlserver.externals.com.google.gson.reflect.TypeToken;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonWriter;

public final class NumberTypeAdapter
extends TypeAdapter<Number> {
    private static final TypeAdapterFactory LAZILY_PARSED_NUMBER_FACTORY = NumberTypeAdapter.newFactory(ToNumberPolicy.LAZILY_PARSED_NUMBER);
    private final ToNumberStrategy toNumberStrategy;

    private NumberTypeAdapter(ToNumberStrategy toNumberStrategy) {
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        final NumberTypeAdapter numberTypeAdapter = new NumberTypeAdapter(toNumberStrategy);
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                return typeToken.getRawType() == Number.class ? numberTypeAdapter : null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.LAZILY_PARSED_NUMBER) {
            return LAZILY_PARSED_NUMBER_FACTORY;
        }
        return NumberTypeAdapter.newFactory(toNumberStrategy);
    }

    @Override
    public Number read(JsonReader jsonReader) throws IOException {
        JsonToken jsonToken = jsonReader.peek();
        switch (jsonToken) {
            case NULL: {
                jsonReader.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.toNumberStrategy.readNumber(jsonReader);
            }
        }
        throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken) + "; at path " + jsonReader.getPath());
    }

    @Override
    public void write(JsonWriter jsonWriter, Number number) throws IOException {
        jsonWriter.value(number);
    }
}

