/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.LookupCache;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap;

public class LRUMap<K, V>
implements LookupCache<K, V>,
Serializable {
    private static final long serialVersionUID = 2L;
    protected final int _initialEntries;
    protected final int _maxEntries;
    protected final transient PrivateMaxEntriesMap<K, V> _map;

    public LRUMap(int n2, int n3) {
        this._initialEntries = n2;
        this._maxEntries = n3;
        this._map = new PrivateMaxEntriesMap.Builder().initialCapacity(n2).maximumCapacity(n3).concurrencyLevel(4).build();
    }

    @Override
    public V put(K k2, V v2) {
        return this._map.put(k2, v2);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        return this._map.putIfAbsent(k2, v2);
    }

    @Override
    public V get(Object object) {
        return this._map.get(object);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    public void contents(BiConsumer<K, V> biConsumer) {
        for (Map.Entry<K, V> entry : this._map.entrySet()) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
    }

    protected Object readResolve() {
        return new LRUMap<K, V>(this._initialEntries, this._maxEntries);
    }
}

